/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.linker.util;

import io.helidon.build.common.FileUtils;
import io.helidon.build.common.OSType;
import io.helidon.build.linker.Application;
import io.helidon.build.linker.Jar;
import io.helidon.build.linker.ResourceContainer;
import io.helidon.build.linker.util.Constants;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleFinder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class JavaRuntime
implements ResourceContainer {
    private static final OSType OS = OSType.currentOS();
    private static final AtomicReference<Path> CURRENT_JAVA_HOME_DIR = new AtomicReference();
    private static final String JMODS_DIR = "jmods";
    private static final String JMOD_SUFFIX = ".jmod";
    private static final String JAVA_BASE_JMOD = "java.base.jmod";
    private static final String JMOD_CLASSES_PREFIX = "classes/";
    private static final String JMOD_MODULE_INFO_PATH = "classes/module-info.class";
    private static final String FILE_SEP = File.separator;
    private static final String JAVA_EXEC = OS.javaExecutable();
    private static final String JAVA_CMD_PATH = "bin" + FILE_SEP + JAVA_EXEC;
    private static final String JAVA_MODULE_NAME_PREFIX = "java.";
    private static final String JDK_MODULE_NAME_PREFIX = "jdk.";
    private static final String HELIDON_JAR_NAME_PREFIX = "helidon-";
    private static final String INVALID_JRI = "This is not a valid JRI (" + JAVA_CMD_PATH + " not found): %s";
    private static final String INCOMPLETE_JDK = "The required *.jmod files (e.g. jmods/%s) are missing in this JDK: %s";
    private static final String HELIDON_JRI = "This is a custom Helidon JRI.";
    private static final String CUSTOM_JRI = "This appears to be a custom JRI.";
    private static final boolean OPEN_JDK = System.getProperty("java.vm.name").toLowerCase(Locale.ENGLISH).contains("openjdk");
    private static final String OPEN_JDK_RPM = "RPM based OpenJDK distributions provide *.jmod files in separate \"java-*-openjdk-jmods\" packages: try 'yum list | grep jmods' to find the package corresponding to your version.";
    private static final String OPEN_JDK_DEB = "Debian based OpenJDK distributions provide *.jmod files only in the \"openjdk-*-jdk-headless\" packages.";
    private static final Map<String, String> OPEN_JDK_LINUX_PACKAGING = Map.of("yum", "RPM based OpenJDK distributions provide *.jmod files in separate \"java-*-openjdk-jmods\" packages: try 'yum list | grep jmods' to find the package corresponding to your version.", "apt", "Debian based OpenJDK distributions provide *.jmod files only in the \"openjdk-*-jdk-headless\" packages.", "apt-get", "Debian based OpenJDK distributions provide *.jmod files only in the \"openjdk-*-jdk-headless\" packages.", "dpkg", "Debian based OpenJDK distributions provide *.jmod files only in the \"openjdk-*-jdk-headless\" packages.", "aptitude", "Debian based OpenJDK distributions provide *.jmod files only in the \"openjdk-*-jdk-headless\" packages.");
    private final Path javaHome;
    private final Runtime.Version version;
    private final boolean isJdk;
    private final Path jmodsDir;
    private final Map<String, Jar> modules;

    private static Path currentJavaHomeDir() {
        Path result = CURRENT_JAVA_HOME_DIR.get();
        if (result == null) {
            result = Paths.get(FileUtils.javaHome(), new String[0]);
            CURRENT_JAVA_HOME_DIR.set(result);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Path prepareJriDirectory(Path jriDirectory, Path mainJar, boolean replaceExisting) {
        if (jriDirectory == null) {
            String jarName = FileUtils.fileName((Path)Objects.requireNonNull(mainJar));
            String dirName = jarName.substring(0, jarName.lastIndexOf(46)) + "-jri";
            jriDirectory = FileUtils.WORKING_DIR.resolve(dirName);
        }
        if (!Files.exists(jriDirectory, new LinkOption[0])) return jriDirectory;
        if (!Files.isDirectory(jriDirectory, new LinkOption[0])) throw new IllegalArgumentException(jriDirectory + " is an existing file");
        if (!replaceExisting) throw new IllegalArgumentException(jriDirectory + " is an existing directory");
        FileUtils.deleteDirectory((Path)jriDirectory);
        return jriDirectory;
    }

    public static Path assertJri(Path jriDirectory) {
        Path result = FileUtils.requireDirectory((Path)jriDirectory);
        if (!JavaRuntime.isValidJri(jriDirectory)) {
            throw new IllegalArgumentException(String.format(INVALID_JRI, jriDirectory));
        }
        return result;
    }

    public static Path assertJdk(Path jdkDirectory) {
        Path result = FileUtils.requireDirectory((Path)jdkDirectory);
        if (!JavaRuntime.isValidJdk(result)) {
            StringBuilder sb = new StringBuilder().append(String.format(INCOMPLETE_JDK, JAVA_BASE_JMOD, jdkDirectory));
            JavaRuntime.incompleteJdkDetailMessage(jdkDirectory).ifPresent(detail -> sb.append(". ").append((String)detail));
            throw new IllegalArgumentException(sb.toString());
        }
        return result;
    }

    public static Path javaCommand(Path jriDirectory) {
        return FileUtils.requireFile((Path)FileUtils.requireDirectory((Path)jriDirectory).resolve(JAVA_CMD_PATH));
    }

    public static JavaRuntime current(boolean assertJdk) {
        Path currentJavaHome = JavaRuntime.currentJavaHomeDir();
        Path jriDir = assertJdk ? JavaRuntime.assertJdk(currentJavaHome) : JavaRuntime.assertJri(currentJavaHome);
        return new JavaRuntime(jriDir, null, assertJdk);
    }

    public static JavaRuntime jdk(Path jdkDirectory) {
        return new JavaRuntime(JavaRuntime.assertJdk(jdkDirectory), null, true);
    }

    public static JavaRuntime jdk(Path jdkDirectory, Runtime.Version version) {
        return new JavaRuntime(JavaRuntime.assertJdk(jdkDirectory), version, true);
    }

    public static JavaRuntime jri(Path jriDirectory, Runtime.Version version) {
        Path jriDir = JavaRuntime.assertJri(jriDirectory);
        boolean isJdk = JavaRuntime.isValidJdk(jriDir);
        return new JavaRuntime(jriDir, version, isJdk);
    }

    private JavaRuntime(Path javaHome, Runtime.Version version, boolean isJdk) {
        this.javaHome = FileUtils.requireDirectory((Path)javaHome);
        this.jmodsDir = javaHome.resolve(JMODS_DIR);
        if (isJdk) {
            List jmodFiles = FileUtils.listFiles((Path)this.jmodsDir, fileName -> fileName.endsWith(JMOD_SUFFIX));
            this.version = this.isCurrent() ? Runtime.version() : this.findVersion();
            this.modules = jmodFiles.stream().filter(file -> !Constants.EXCLUDED_MODULES.contains(JavaRuntime.moduleNameOf(file))).collect(Collectors.toMap(JavaRuntime::moduleNameOf, jmod -> Jar.open(jmod, this.version)));
        } else {
            if (version == null) {
                throw new IllegalArgumentException("Version required in a Java Runtime without 'jmods' dir: " + javaHome);
            }
            this.version = version;
            this.modules = Map.of();
        }
        this.isJdk = isJdk;
    }

    public Runtime.Version version() {
        return this.version;
    }

    public String featureVersion() {
        return Integer.toString(this.version.feature());
    }

    public Path path() {
        return this.javaHome;
    }

    @Override
    public boolean containsResource(String resourcePath) {
        Object path = resourcePath.endsWith(".class") ? JMOD_CLASSES_PREFIX + resourcePath : resourcePath;
        return this.modules.values().stream().anyMatch(arg_0 -> JavaRuntime.lambda$containsResource$4((String)path, arg_0));
    }

    public boolean isCurrent() {
        return this.javaHome.equals(JavaRuntime.currentJavaHomeDir());
    }

    public Set<String> moduleNames() {
        return this.modules.keySet();
    }

    public Jar jmod(String moduleName) {
        Jar result = this.modules.get(moduleName);
        if (result == null) {
            throw new IllegalArgumentException("Cannot find .jmod file for module '" + moduleName + "' in " + this.path());
        }
        return result;
    }

    public Path jmodsDir() {
        return Objects.requireNonNull(this.jmodsDir);
    }

    public Path ensureDirectory(Path directory) {
        Path relativeDir = Objects.requireNonNull(directory);
        if (directory.isAbsolute()) {
            relativeDir = this.path().relativize(directory);
        }
        return FileUtils.ensureDirectory((Path)this.path().resolve(relativeDir), (FileAttribute[])new FileAttribute[0]);
    }

    public long diskSize() {
        return FileUtils.sizeOf((Path)this.path());
    }

    public String toString() {
        return (this.isJdk ? "JDK " : "JRI ") + this.version;
    }

    private Runtime.Version findVersion() {
        Runtime.Version version;
        Path javaBase = FileUtils.requireFile((Path)this.jmodsDir.resolve(JAVA_BASE_JMOD));
        ZipFile zip = new ZipFile(javaBase.toFile());
        try {
            ZipEntry entry = zip.getEntry(JMOD_MODULE_INFO_PATH);
            if (entry == null) {
                throw new IllegalStateException("Cannot find classes/module-info.class in " + javaBase);
            }
            ModuleDescriptor descriptor = ModuleDescriptor.read(zip.getInputStream(entry));
            version = Runtime.Version.parse(descriptor.version().orElseThrow(() -> new IllegalStateException("No version in " + javaBase)).toString());
        }
        catch (Throwable throwable) {
            try {
                try {
                    zip.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        zip.close();
        return version;
    }

    private static boolean isValidJri(Path jriDirectory) {
        Path javaCommand = jriDirectory.resolve(JAVA_CMD_PATH);
        return Files.isRegularFile(javaCommand, new LinkOption[0]);
    }

    private static boolean isValidJdk(Path jdkDirectory) {
        if (JavaRuntime.isValidJri(jdkDirectory)) {
            Path jmodsDir = jdkDirectory.resolve(JMODS_DIR);
            Path javaBase = jmodsDir.resolve(JAVA_BASE_JMOD);
            return Files.isDirectory(jmodsDir, new LinkOption[0]) && Files.exists(javaBase, new LinkOption[0]);
        }
        return false;
    }

    private static Optional<String> incompleteJdkDetailMessage(Path jdkDirectory) {
        if (JavaRuntime.isHelidonJri(jdkDirectory)) {
            return Optional.of(HELIDON_JRI);
        }
        if (JavaRuntime.isCustomJri(jdkDirectory)) {
            return Optional.of(CUSTOM_JRI);
        }
        if (OPEN_JDK && OS == OSType.Linux) {
            return OPEN_JDK_LINUX_PACKAGING.entrySet().stream().filter(e -> FileUtils.findExecutableInPath((String)((String)e.getKey())).isPresent()).map(Map.Entry::getValue).findFirst();
        }
        return Optional.empty();
    }

    private static boolean isCustomJri(Path jdkDirectory) {
        if (jdkDirectory.equals(JavaRuntime.currentJavaHomeDir())) {
            return ModuleFinder.ofSystem().findAll().stream().map(ref -> ref.descriptor().name()).anyMatch(moduleName -> !moduleName.startsWith(JAVA_MODULE_NAME_PREFIX) && !moduleName.startsWith(JDK_MODULE_NAME_PREFIX));
        }
        return false;
    }

    private static boolean isHelidonJri(Path jdkDirectory) {
        Path appDir = jdkDirectory.resolve(Application.APP_DIR);
        if (Files.isDirectory(appDir, new LinkOption[0])) {
            return FileUtils.list((Path)appDir, (int)2).stream().anyMatch(path -> path.getFileName().toString().startsWith(HELIDON_JAR_NAME_PREFIX));
        }
        return false;
    }

    private static String moduleNameOf(Path jmodFile) {
        String fileName = FileUtils.fileName((Path)jmodFile);
        return fileName.substring(0, fileName.length() - JMOD_SUFFIX.length());
    }

    private static /* synthetic */ boolean lambda$containsResource$4(String path, Jar jar) {
        return jar.containsResource(path);
    }
}

