/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.common.logging;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public enum LogLevel {
    DEBUG,
    VERBOSE,
    INFO,
    WARN,
    ERROR;

    public static final String LEVEL_PROPERTY = "log.level";
    private static final String DEFAULT_LEVEL = "info";
    private static final AtomicReference<LogLevel> VALUE;

    private static LogLevel defaultLevel() {
        return LogLevel.valueOf(System.getProperty(LEVEL_PROPERTY, DEFAULT_LEVEL).toUpperCase());
    }

    public static void set(LogLevel level) {
        VALUE.set(Objects.requireNonNull(level, "level is null"));
    }

    public static LogLevel get() {
        return VALUE.get();
    }

    public static boolean isDebug() {
        return LogLevel.get() == DEBUG;
    }

    public static boolean isVerbose() {
        LogLevel level = LogLevel.get();
        return level == VERBOSE || level == DEBUG;
    }

    static {
        VALUE = new AtomicReference<LogLevel>(LogLevel.defaultLevel());
    }
}

