/*
 * Decompiled with CFR 0.152.
 */
package io.github.yezhihao.netmc.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.util.function.BiFunction;

public interface Client
extends Closeable {
    public static final BiFunction<InetAddress, Integer, Client> UDP = (target, port) -> new Client((InetAddress)target, (Integer)port){
        private final DatagramSocket client = Client.newDatagramSocket();
        final /* synthetic */ InetAddress val$target;
        final /* synthetic */ Integer val$port;
        {
            this.val$target = inetAddress;
            this.val$port = n;
        }

        @Override
        public void send(byte[] bytes) throws IOException {
            this.client.send(new DatagramPacket(bytes, bytes.length, this.val$target, this.val$port));
        }

        @Override
        public void close() {
            this.client.close();
        }
    };
    public static final BiFunction<InetAddress, Integer, Client> TCP = (target, port) -> new Client((InetAddress)target, (Integer)port){
        private final Socket client;
        final /* synthetic */ InetAddress val$target;
        final /* synthetic */ Integer val$port;
        {
            this.val$target = inetAddress;
            this.val$port = n;
            this.client = Client.newSocket(this.val$target, this.val$port);
        }

        @Override
        public void send(byte[] bytes) throws IOException {
            OutputStream os = this.client.getOutputStream();
            os.write(bytes);
            os.flush();
        }

        @Override
        public void close() {
            try {
                this.client.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    };

    public void send(byte[] var1) throws IOException;

    public static Client[] UDP(String host, int port, int size) {
        InetAddress target = Client.newInetAddress(host);
        Client[] result = new Client[size];
        for (int i = 0; i < size; ++i) {
            result[i] = UDP.apply(target, port);
        }
        return result;
    }

    public static Client[] TCP(String host, int port, int size) {
        InetAddress target = Client.newInetAddress(host);
        Client[] result = new Client[size];
        for (int i = 0; i < size; ++i) {
            result[i] = TCP.apply(target, port);
        }
        return result;
    }

    public static InetAddress newInetAddress(String host) {
        try {
            return InetAddress.getByName(host);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Socket newSocket(InetAddress target, int port) {
        try {
            return new Socket(target, port);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static DatagramSocket newDatagramSocket() {
        try {
            return new DatagramSocket();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

