/*
 * Decompiled with CFR 0.152.
 */
package io.github.yezhihao.netmc.session;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.github.yezhihao.netmc.session.Session;
import io.github.yezhihao.netmc.session.SessionListener;
import io.netty.channel.Channel;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionManager {
    private static final Logger log = LoggerFactory.getLogger(SessionManager.class);
    private final Map<String, Session> sessionMap = new ConcurrentHashMap<String, Session>();
    private final Cache<String, Object> offlineCache = Caffeine.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();
    private final SessionListener sessionListener;
    private final Class<? extends Enum> sessionKeyClass;

    public SessionManager() {
        this(null, null);
    }

    public SessionManager(SessionListener sessionListener) {
        this(null, sessionListener);
    }

    public SessionManager(Class<? extends Enum> sessionKeyClass, SessionListener sessionListener) {
        this.sessionKeyClass = sessionKeyClass;
        this.sessionListener = sessionListener;
    }

    public Session get(String sessionId) {
        return this.sessionMap.get(sessionId);
    }

    public Collection<Session> all() {
        return this.sessionMap.values();
    }

    public Session newInstance(Channel channel) {
        InetSocketAddress sender = (InetSocketAddress)channel.remoteAddress();
        Session session = new Session(this, channel, sender, s -> {
            channel.close();
            return true;
        }, false);
        if (this.sessionListener != null) {
            try {
                this.sessionListener.sessionCreated(session);
            }
            catch (Exception e) {
                log.error("sessionCreated", (Throwable)e);
            }
        }
        return session;
    }

    public Session newInstance(Channel channel, InetSocketAddress sender, Function<Session, Boolean> remover) {
        Session session = new Session(this, channel, sender, remover, true);
        if (this.sessionListener != null) {
            try {
                this.sessionListener.sessionCreated(session);
            }
            catch (Exception e) {
                log.error("sessionCreated", (Throwable)e);
            }
        }
        return session;
    }

    protected void remove(Session session) {
        boolean remove = this.sessionMap.remove(session.getId(), session);
        if (remove && this.sessionListener != null) {
            try {
                this.sessionListener.sessionDestroyed(session);
            }
            catch (Exception e) {
                log.error("sessionDestroyed", (Throwable)e);
            }
        }
    }

    protected void add(Session newSession) {
        Session oldSession = this.sessionMap.put(newSession.getId(), newSession);
        if (this.sessionListener != null) {
            try {
                this.sessionListener.sessionRegistered(newSession);
            }
            catch (Exception e) {
                log.error("sessionRegistered", (Throwable)e);
            }
        }
    }

    public void setOfflineCache(String clientId, Object value) {
        this.offlineCache.put((Object)clientId, value);
    }

    public Object getOfflineCache(String clientId) {
        return this.offlineCache.getIfPresent((Object)clientId);
    }

    public Class<? extends Enum> getSessionKeyClass() {
        return this.sessionKeyClass;
    }
}

