/*
 * Decompiled with CFR 0.152.
 */
package io.github.yezhihao.netmc.session;

import io.github.yezhihao.netmc.core.model.Message;
import io.github.yezhihao.netmc.core.model.Response;
import io.github.yezhihao.netmc.session.Packet;
import io.github.yezhihao.netmc.session.SessionManager;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

public class Session {
    private static final Logger log = LoggerFactory.getLogger(Session.class);
    private final boolean udp;
    private final Function<Session, Boolean> remover;
    protected final Channel channel;
    private final SessionManager sessionManager;
    private final InetSocketAddress remoteAddress;
    private final String remoteAddressStr;
    private final long creationTime;
    private long lastAccessedTime;
    private final Map<Object, Object> attributes;
    private String sessionId;
    private String clientId;
    private final AtomicInteger serialNo = new AtomicInteger(0);
    private final Map<String, MonoSink> topicSubscribers = new HashMap<String, MonoSink>();
    private static final Mono Rejected = Mono.error((Throwable)new RejectedExecutionException("\u5ba2\u6237\u7aef\u6682\u672a\u54cd\u5e94\uff0c\u8bf7\u52ff\u91cd\u590d\u53d1\u9001"));

    public Session(SessionManager sessionManager, Channel channel, InetSocketAddress remoteAddress, Function<Session, Boolean> remover, boolean udp) {
        this.channel = channel;
        this.lastAccessedTime = this.creationTime = System.currentTimeMillis();
        this.sessionManager = sessionManager;
        this.remoteAddress = remoteAddress;
        this.remoteAddressStr = remoteAddress.toString();
        this.remover = remover;
        this.udp = udp;
        this.attributes = sessionManager != null && sessionManager.getSessionKeyClass() != null ? new EnumMap<Enum, Object>(sessionManager.getSessionKeyClass()) : new TreeMap<Object, Object>();
    }

    public void register(Message message) {
        this.register(message.getClientId(), message);
    }

    public void register(String sessionId, Message message) {
        if (sessionId == null) {
            throw new NullPointerException("sessionId not null");
        }
        this.sessionId = sessionId;
        this.clientId = message.getClientId();
        if (this.sessionManager != null) {
            this.sessionManager.add(this);
        }
        log.info("<<<<<\u7ec8\u7aef\u6ce8\u518c{}", (Object)this);
    }

    public boolean isRegistered() {
        return this.sessionId != null;
    }

    public String getId() {
        return this.sessionId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    public long access() {
        this.lastAccessedTime = System.currentTimeMillis();
        return this.lastAccessedTime;
    }

    public Collection<Object> getAttributeNames() {
        return this.attributes.keySet();
    }

    public Map<Object, Object> getAttributes() {
        return this.attributes;
    }

    public Object getAttribute(Object name) {
        return this.attributes.get(name);
    }

    public void setAttribute(Object name, Object value) {
        this.attributes.put(name, value);
    }

    public Object removeAttribute(Object name) {
        return this.attributes.remove(name);
    }

    public Object getOfflineCache(String clientId) {
        if (this.sessionManager != null) {
            return this.sessionManager.getOfflineCache(clientId);
        }
        return null;
    }

    public void setOfflineCache(String clientId, Object value) {
        if (this.sessionManager != null) {
            this.sessionManager.setOfflineCache(clientId, value);
        }
    }

    public InetSocketAddress remoteAddress() {
        return this.remoteAddress;
    }

    public int nextSerialNo() {
        int next;
        int current;
        while (!this.serialNo.compareAndSet(current, (next = (current = this.serialNo.get()) > 65535 ? 0 : current) + 1)) {
        }
        return next;
    }

    public void invalidate() {
        if (this.isRegistered() && this.sessionManager != null) {
            this.sessionManager.remove(this);
        }
        this.remover.apply(this);
    }

    public String getRemoteAddressStr() {
        return this.remoteAddressStr;
    }

    public boolean isUdp() {
        return this.udp;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(50);
        sb.append(this.remoteAddressStr);
        sb.append('/').append(this.sessionId);
        if (this.sessionId != this.clientId) {
            sb.append('/').append(this.clientId);
        }
        return sb.toString();
    }

    public Mono<Void> notify(Message message) {
        return Session.mono(this.channel.writeAndFlush((Object)Packet.of(this, message)));
    }

    public Mono<Void> notify(ByteBuf message) {
        return Session.mono(this.channel.writeAndFlush((Object)Packet.of(this, message)));
    }

    private static Mono<Void> mono(ChannelFuture channelFuture) {
        Mono mono = Mono.create(sink -> channelFuture.addListener(future -> {
            if (future.isSuccess()) {
                sink.success();
            } else {
                sink.error(future.cause());
            }
        }));
        return mono;
    }

    public <T> Mono<T> request(Message request, Class<T> responseClass) {
        String key = Session.requestKey(request, responseClass);
        Mono receive = this.subscribe(key);
        if (receive == null) {
            return Rejected;
        }
        ChannelFuture channelFuture = this.channel.writeAndFlush((Object)Packet.of(this, request));
        Mono mono = Mono.create(sink -> channelFuture.addListener(future -> {
            if (future.isSuccess()) {
                sink.success((Object)future);
            } else {
                sink.error(future.cause());
            }
        })).then(receive).doFinally(signal -> this.unsubscribe(key));
        return mono;
    }

    public boolean response(Message message) {
        MonoSink sink = this.topicSubscribers.get(Session.responseKey(message));
        if (sink != null) {
            sink.success((Object)message);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Mono subscribe(String key) {
        Map<String, MonoSink> map = this.topicSubscribers;
        synchronized (map) {
            if (!this.topicSubscribers.containsKey(key)) {
                return Mono.create(sink -> this.topicSubscribers.put(key, (MonoSink)sink));
            }
        }
        return null;
    }

    private void unsubscribe(String key) {
        this.topicSubscribers.remove(key);
    }

    private static String requestKey(Message request, Class responseClass) {
        String className = responseClass.getName();
        if (Response.class.isAssignableFrom(responseClass)) {
            int serialNo = request.getSerialNo();
            return new StringBuilder(34).append(className).append('.').append(serialNo).toString();
        }
        return className;
    }

    private static String responseKey(Object response) {
        String className = response.getClass().getName();
        if (response instanceof Response) {
            int serialNo = ((Response)response).getResponseSerialNo();
            return new StringBuilder(34).append(className).append('.').append(serialNo).toString();
        }
        return className;
    }
}

