/*
 * Decompiled with CFR 0.152.
 */
package io.github.yezhihao.netmc.handler;

import io.github.yezhihao.netmc.codec.Delimiter;
import io.github.yezhihao.netmc.session.Packet;
import io.github.yezhihao.netmc.session.Session;
import io.github.yezhihao.netmc.session.SessionManager;
import io.github.yezhihao.netmc.util.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.codec.DecoderException;
import java.net.InetSocketAddress;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class UDPMessageAdapter
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(UDPMessageAdapter.class);
    private final SessionManager sessionManager;
    private final long readerIdleTime;
    private final Map<Object, Session> sessionMap = new ConcurrentHashMap<Object, Session>();

    public static UDPMessageAdapter newInstance(SessionManager sessionManager, int readerIdleTime, Delimiter[] delimiters) {
        if (delimiters == null) {
            return new UDPMessageAdapter(sessionManager, readerIdleTime);
        }
        return new DelimiterBasedFrameImpl(sessionManager, readerIdleTime, delimiters);
    }

    private UDPMessageAdapter(SessionManager sessionManager, int readerIdleTime) {
        this.sessionManager = sessionManager;
        this.readerIdleTime = TimeUnit.SECONDS.toMillis(readerIdleTime);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        DatagramPacket packet = (DatagramPacket)msg;
        ByteBuf buf = (ByteBuf)packet.content();
        Session session = this.getSession(ctx, (InetSocketAddress)packet.sender());
        session.access();
        ctx.fireChannelRead((Object)Packet.of(session, buf));
    }

    protected Session getSession(ChannelHandlerContext ctx, InetSocketAddress sender) {
        Session session = this.sessionMap.get(sender);
        if (session == null) {
            session = this.sessionManager.newInstance(ctx.channel(), sender, s -> this.sessionMap.remove(sender, s));
            this.sessionMap.put(sender, session);
            log.info("<<<<<\u7ec8\u7aef\u8fde\u63a5{}", (Object)session);
        }
        return session;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        Thread thread = new Thread(() -> {
            while (true) {
                long nextDelay = this.readerIdleTime;
                long now = System.currentTimeMillis();
                for (Session session : this.sessionMap.values()) {
                    long time = this.readerIdleTime - (now - session.getLastAccessedTime());
                    if (time <= 0L) {
                        log.warn(">>>>>\u7ec8\u7aef\u5fc3\u8df3\u8d85\u65f6 {}", (Object)session);
                        session.invalidate();
                        continue;
                    }
                    nextDelay = Math.min(time, nextDelay);
                }
                try {
                    Thread.sleep(nextDelay);
                    continue;
                }
                catch (Throwable e) {
                    log.warn("IdleStateScheduler", e);
                    continue;
                }
                break;
            }
        });
        thread.setName(Thread.currentThread().getName() + "-c");
        thread.setPriority(1);
        thread.setDaemon(true);
        thread.start();
    }

    private static class DelimiterBasedFrameImpl
    extends UDPMessageAdapter {
        private final Delimiter[] delimiters;

        private DelimiterBasedFrameImpl(SessionManager sessionManager, int readerIdleTime, Delimiter[] delimiters) {
            super(sessionManager, readerIdleTime);
            this.delimiters = delimiters;
        }

        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            DatagramPacket packet = (DatagramPacket)msg;
            ByteBuf buf = (ByteBuf)packet.content();
            Session session = this.getSession(ctx, (InetSocketAddress)packet.sender());
            try {
                List<ByteBuf> out = this.decode(buf);
                for (ByteBuf t : out) {
                    ctx.fireChannelRead((Object)Packet.of(session, t));
                }
            }
            catch (DecoderException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DecoderException((Throwable)e);
            }
            finally {
                buf.release();
            }
        }

        protected List<ByteBuf> decode(ByteBuf in) {
            LinkedList<ByteBuf> out = new LinkedList<ByteBuf>();
            while (in.isReadable()) {
                for (Delimiter delim : this.delimiters) {
                    int minDelimLength = delim.value.length;
                    int frameLength = ByteBufUtils.indexOf(in, delim.value);
                    if (frameLength >= 0) {
                        if (delim.strip) {
                            if (frameLength != 0) {
                                out.add(in.readRetainedSlice(frameLength));
                            }
                            in.skipBytes(minDelimLength);
                            continue;
                        }
                        if (frameLength != 0) {
                            out.add(in.readRetainedSlice(frameLength + minDelimLength));
                            continue;
                        }
                        in.skipBytes(minDelimLength);
                        continue;
                    }
                    int i = in.readableBytes();
                    if (i <= 0) continue;
                    out.add(in.readRetainedSlice(i));
                }
            }
            return out;
        }
    }
}

