/*
 * Decompiled with CFR 0.152.
 */
package io.github.yezhihao.netmc.handler;

import io.github.yezhihao.netmc.session.Packet;
import io.github.yezhihao.netmc.session.Session;
import io.github.yezhihao.netmc.session.SessionManager;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.AttributeKey;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class TCPMessageAdapter
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(TCPMessageAdapter.class);
    private static final AttributeKey<Session> KEY = AttributeKey.newInstance((String)Session.class.getName());
    private final SessionManager sessionManager;

    public TCPMessageAdapter(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        ByteBuf buf = (ByteBuf)msg;
        Session session = this.getSession(ctx);
        session.access();
        ctx.fireChannelRead((Object)Packet.of(session, buf));
    }

    private Session getSession(ChannelHandlerContext ctx) {
        Session session = (Session)ctx.channel().attr(KEY).get();
        if (session == null) {
            Channel channel = ctx.channel();
            session = this.sessionManager.newInstance(channel);
            channel.attr(KEY).set((Object)session);
        }
        return session;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        log.info("<<<<<\u7ec8\u7aef\u8fde\u63a5{}", (Object)ctx.channel().remoteAddress());
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        Session session = (Session)ctx.channel().attr(KEY).get();
        if (session != null) {
            session.invalidate();
        }
        log.info(">>>>>\u65ad\u5f00\u8fde\u63a5{}", TCPMessageAdapter.client(ctx));
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable e) {
        if (e instanceof IOException) {
            log.warn("<<<<<\u7ec8\u7aef\u65ad\u5f00\u8fde\u63a5{} {}", TCPMessageAdapter.client(ctx), (Object)e.getMessage());
        } else {
            log.warn(">>>>>\u6d88\u606f\u5904\u7406\u5f02\u5e38" + TCPMessageAdapter.client(ctx), e);
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        IdleStateEvent event;
        IdleState state;
        if (evt instanceof IdleStateEvent && ((state = (event = (IdleStateEvent)evt).state()) == IdleState.READER_IDLE || state == IdleState.WRITER_IDLE || state == IdleState.ALL_IDLE)) {
            log.warn(">>>>>\u7ec8\u7aef\u5fc3\u8df3\u8d85\u65f6{} {}", (Object)state, TCPMessageAdapter.client(ctx));
            ctx.close();
        }
    }

    private static Object client(ChannelHandlerContext ctx) {
        Channel channel = ctx.channel();
        Session session = (Session)channel.attr(KEY).get();
        if (session != null) {
            return session;
        }
        return channel.remoteAddress();
    }
}

