/*
 * Decompiled with CFR 0.152.
 */
package io.github.yezhihao.netmc.handler;

import io.github.yezhihao.netmc.codec.MessageEncoder;
import io.github.yezhihao.netmc.session.Packet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.EncoderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class MessageEncoderWrapper
extends ChannelOutboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(MessageEncoderWrapper.class);
    private final MessageEncoder encoder;

    public MessageEncoderWrapper(MessageEncoder encoder) {
        this.encoder = encoder;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        Packet packet = (Packet)msg;
        ByteBuf output = packet.take();
        try {
            if (output == null) {
                output = this.encoder.encode(packet.message, packet.session);
            }
            if (output.isReadable()) {
                ctx.write(packet.wrap(output), promise);
            } else {
                output.release();
                ctx.write(packet.wrap(Unpooled.EMPTY_BUFFER), promise);
            }
            output = null;
        }
        catch (EncoderException e) {
            log.error("\u6d88\u606f\u7f16\u7801\u5f02\u5e38" + packet.message, (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            log.error("\u6d88\u606f\u7f16\u7801\u5f02\u5e38" + packet.message, e);
            throw new EncoderException(e);
        }
        finally {
            if (output != null) {
                output.release();
            }
        }
    }
}

