/*
 * Decompiled with CFR 0.152.
 */
package io.github.yezhihao.netmc.handler;

import io.github.yezhihao.netmc.codec.MessageDecoder;
import io.github.yezhihao.netmc.core.model.Message;
import io.github.yezhihao.netmc.session.Packet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.DecoderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class MessageDecoderWrapper
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(MessageDecoderWrapper.class);
    private final MessageDecoder decoder;

    public MessageDecoderWrapper(MessageDecoder decoder) {
        this.decoder = decoder;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        Packet packet = (Packet)msg;
        ByteBuf input = packet.take();
        try {
            Object message = this.decoder.decode(input, packet.session);
            if (message != null) {
                ctx.fireChannelRead((Object)packet.replace((Message)message));
            }
            input.skipBytes(input.readableBytes());
        }
        catch (Exception e) {
            log.error("\u6d88\u606f\u89e3\u7801\u5f02\u5e38[" + ByteBufUtil.hexDump((ByteBuf)input, (int)0, (int)input.writerIndex()) + "]", (Throwable)e);
            throw new DecoderException((Throwable)e);
        }
        finally {
            input.release();
        }
    }
}

