/*
 * Decompiled with CFR 0.152.
 */
package io.github.yezhihao.netmc.handler;

import io.github.yezhihao.netmc.core.HandlerInterceptor;
import io.github.yezhihao.netmc.core.HandlerMapping;
import io.github.yezhihao.netmc.core.handler.Handler;
import io.github.yezhihao.netmc.core.model.Message;
import io.github.yezhihao.netmc.session.Packet;
import io.github.yezhihao.netmc.session.Session;
import io.github.yezhihao.netmc.util.Stopwatch;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class DispatcherHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(DispatcherHandler.class);
    private final HandlerMapping handlerMapping;
    private final HandlerInterceptor interceptor;
    private final ExecutorService executor;
    public static boolean STOPWATCH = false;
    private static Stopwatch s;

    public DispatcherHandler(HandlerMapping handlerMapping, HandlerInterceptor interceptor, ExecutorService executor) {
        if (STOPWATCH && s == null) {
            s = new Stopwatch().start();
        }
        this.handlerMapping = handlerMapping;
        this.interceptor = interceptor;
        this.executor = executor;
    }

    public final void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (STOPWATCH) {
            s.increment();
        }
        Packet packet = (Packet)msg;
        Message request = packet.message;
        Handler handler = this.handlerMapping.getHandler(request.getMessageId());
        if (handler == null) {
            Message response = this.interceptor.notSupported(request, packet.session);
            if (response != null) {
                ctx.writeAndFlush((Object)packet.replace(response));
            }
        } else if (handler.async) {
            this.executor.execute(() -> this.channelRead0(ctx, packet, handler));
        } else {
            this.channelRead0(ctx, packet, handler);
        }
    }

    private void channelRead0(ChannelHandlerContext ctx, Packet packet, Handler handler) {
        Message response;
        Session session = packet.session;
        Message request = packet.message;
        long time = System.currentTimeMillis();
        try {
            if (!this.interceptor.beforeHandle(request, session)) {
                return;
            }
            response = handler.invoke(request, session);
            if (handler.returnVoid) {
                response = this.interceptor.successful(request, session);
            } else {
                this.interceptor.afterHandle(request, response, session);
            }
        }
        catch (Exception e) {
            log.warn(String.valueOf(request), (Throwable)e);
            response = this.interceptor.exceptional(request, session, e);
        }
        time = System.currentTimeMillis() - time;
        if (time > 100L) {
            log.info("====={},\u6162\u5904\u7406\u8017\u65f6{}ms", (Object)handler, (Object)time);
        }
        if (response != null) {
            ctx.writeAndFlush((Object)packet.replace(response));
        }
    }
}

