/*
 * Decompiled with CFR 0.152.
 */
package io.github.yezhihao.netmc.core;

import io.github.yezhihao.netmc.core.HandlerMapping;
import io.github.yezhihao.netmc.core.annotation.Async;
import io.github.yezhihao.netmc.core.annotation.AsyncBatch;
import io.github.yezhihao.netmc.core.annotation.Mapping;
import io.github.yezhihao.netmc.core.handler.AsyncBatchHandler;
import io.github.yezhihao.netmc.core.handler.Handler;
import io.github.yezhihao.netmc.core.handler.SimpleHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractHandlerMapping
implements HandlerMapping {
    private final Map<Object, Handler> handlerMap = new HashMap<Object, Handler>(64);

    protected synchronized void registerHandlers(Object bean) {
        Method[] methods;
        Class<?> beanClass = bean.getClass();
        for (Method method : methods = beanClass.getDeclaredMethods()) {
            Mapping mapping = method.getAnnotation(Mapping.class);
            if (mapping == null) continue;
            String desc = mapping.desc();
            int[] types = mapping.types();
            AsyncBatch asyncBatch = method.getAnnotation(AsyncBatch.class);
            Handler handler = asyncBatch != null ? new AsyncBatchHandler(bean, method, desc, asyncBatch.poolSize(), asyncBatch.maxElements(), asyncBatch.maxWait()) : new SimpleHandler(bean, method, desc, method.isAnnotationPresent(Async.class));
            for (int type : types) {
                this.handlerMap.put(type, handler);
            }
        }
    }

    @Override
    public Handler getHandler(int messageId) {
        return this.handlerMap.get(messageId);
    }
}

