/*
 * Decompiled with CFR 0.152.
 */
package io.github.yezhihao.netmc;

import io.github.yezhihao.netmc.NettyConfig;
import io.github.yezhihao.netmc.Server;
import io.github.yezhihao.netmc.handler.DispatcherHandler;
import io.github.yezhihao.netmc.handler.MessageDecoderWrapper;
import io.github.yezhihao.netmc.handler.MessageEncoderWrapper;
import io.github.yezhihao.netmc.handler.UDPMessageAdapter;
import io.netty.bootstrap.AbstractBootstrap;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioChannelOption;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class UDPServer
extends Server {
    protected UDPServer(NettyConfig config) {
        super(config);
    }

    @Override
    protected AbstractBootstrap initialize() {
        this.bossGroup = new NioEventLoopGroup(1, (ThreadFactory)new DefaultThreadFactory(this.config.name, 10));
        if (this.config.businessCore > 0) {
            this.businessGroup = new ThreadPoolExecutor(this.config.businessCore, this.config.businessCore, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new DefaultThreadFactory(this.config.name + "-B", true, 5));
        }
        return ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.bossGroup)).channel(NioDatagramChannel.class)).option(NioChannelOption.SO_REUSEADDR, (Object)true)).option(NioChannelOption.SO_RCVBUF, (Object)0x3200000)).handler((ChannelHandler)new ChannelInitializer<NioDatagramChannel>(){
            private final UDPMessageAdapter adapter;
            private final MessageDecoderWrapper decoder;
            private final MessageEncoderWrapper encoder;
            private final DispatcherHandler dispatcher;
            {
                this.adapter = UDPMessageAdapter.newInstance(UDPServer.this.config.sessionManager, UDPServer.this.config.readerIdleTime, UDPServer.this.config.delimiters);
                this.decoder = new MessageDecoderWrapper(UDPServer.this.config.decoder);
                this.encoder = new MessageEncoderWrapper(UDPServer.this.config.encoder);
                this.dispatcher = new DispatcherHandler(UDPServer.this.config.handlerMapping, UDPServer.this.config.handlerInterceptor, UDPServer.this.businessGroup);
            }

            public void initChannel(NioDatagramChannel channel) {
                channel.pipeline().addLast("adapter", (ChannelHandler)this.adapter).addLast("decoder", (ChannelHandler)this.decoder).addLast("encoder", (ChannelHandler)this.encoder).addLast("dispatcher", (ChannelHandler)this.dispatcher);
            }
        });
    }
}

