/*
 * Decompiled with CFR 0.152.
 */
package io.github.yezhihao.netmc;

import io.github.yezhihao.netmc.NettyConfig;
import io.github.yezhihao.netmc.Server;
import io.github.yezhihao.netmc.handler.DelimiterBasedFrameDecoder;
import io.github.yezhihao.netmc.handler.DispatcherHandler;
import io.github.yezhihao.netmc.handler.LengthFieldAndDelimiterFrameDecoder;
import io.github.yezhihao.netmc.handler.MessageDecoderWrapper;
import io.github.yezhihao.netmc.handler.MessageEncoderWrapper;
import io.github.yezhihao.netmc.handler.TCPMessageAdapter;
import io.netty.bootstrap.AbstractBootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioChannelOption;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class TCPServer
extends Server {
    protected TCPServer(NettyConfig config) {
        super(config);
    }

    @Override
    protected AbstractBootstrap initialize() {
        this.bossGroup = new NioEventLoopGroup(1, (ThreadFactory)new DefaultThreadFactory(this.config.name, 10));
        this.workerGroup = new NioEventLoopGroup(this.config.workerCore, (ThreadFactory)new DefaultThreadFactory(this.config.name, 10));
        if (this.config.businessCore > 0) {
            this.businessGroup = new ThreadPoolExecutor(this.config.businessCore, this.config.businessCore, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new DefaultThreadFactory(this.config.name + "-B", true, 5));
        }
        return ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).option(NioChannelOption.SO_REUSEADDR, (Object)true)).option(NioChannelOption.SO_BACKLOG, (Object)1024)).childOption(NioChannelOption.TCP_NODELAY, (Object)true).childHandler((ChannelHandler)new ChannelInitializer<NioSocketChannel>(){
            private final TCPMessageAdapter adapter;
            private final MessageDecoderWrapper decoder;
            private final MessageEncoderWrapper encoder;
            private final DispatcherHandler dispatcher;
            {
                this.adapter = new TCPMessageAdapter(TCPServer.this.config.sessionManager);
                this.decoder = new MessageDecoderWrapper(TCPServer.this.config.decoder);
                this.encoder = new MessageEncoderWrapper(TCPServer.this.config.encoder);
                this.dispatcher = new DispatcherHandler(TCPServer.this.config.handlerMapping, TCPServer.this.config.handlerInterceptor, TCPServer.this.businessGroup);
            }

            public void initChannel(NioSocketChannel channel) {
                channel.pipeline().addLast(new ChannelHandler[]{new IdleStateHandler(TCPServer.this.config.readerIdleTime, TCPServer.this.config.writerIdleTime, TCPServer.this.config.allIdleTime)}).addLast("frameDecoder", (ChannelHandler)TCPServer.this.frameDecoder()).addLast("adapter", (ChannelHandler)this.adapter).addLast("decoder", (ChannelHandler)this.decoder).addLast("encoder", (ChannelHandler)this.encoder).addLast("dispatcher", (ChannelHandler)this.dispatcher);
            }
        });
    }

    private ByteToMessageDecoder frameDecoder() {
        if (this.config.lengthField == null) {
            return new DelimiterBasedFrameDecoder((int)this.config.maxFrameLength, this.config.delimiters);
        }
        return new LengthFieldAndDelimiterFrameDecoder((int)this.config.maxFrameLength, this.config.lengthField, this.config.delimiters);
    }
}

