/*
 * Decompiled with CFR 0.152.
 */
package io.github.yezhihao.netmc;

import io.github.yezhihao.netmc.NettyConfig;
import io.netty.bootstrap.AbstractBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.EventLoopGroup;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Server {
    protected static final Logger log = LoggerFactory.getLogger(Server.class);
    protected boolean isRunning;
    protected final NettyConfig config;
    protected EventLoopGroup bossGroup;
    protected EventLoopGroup workerGroup;
    protected ExecutorService businessGroup;

    protected Server(NettyConfig config) {
        this.config = config;
    }

    protected abstract AbstractBootstrap initialize();

    public synchronized boolean start() {
        if (this.isRunning) {
            log.warn("==={}\u5df2\u7ecf\u542f\u52a8,port:{}===", (Object)this.config.name, (Object)this.config.port);
            return this.isRunning;
        }
        AbstractBootstrap bootstrap = this.initialize();
        ChannelFuture future = bootstrap.bind(this.config.port.intValue()).awaitUninterruptibly();
        future.channel().closeFuture().addListener(f -> {
            if (this.isRunning) {
                this.stop();
            }
        });
        if (future.cause() != null) {
            log.error("\u542f\u52a8\u5931\u8d25", future.cause());
        }
        if (this.isRunning = future.isSuccess()) {
            log.warn("==={}\u542f\u52a8\u6210\u529f,port:{}===", (Object)this.config.name, (Object)this.config.port);
        }
        return this.isRunning;
    }

    public synchronized void stop() {
        this.isRunning = false;
        this.bossGroup.shutdownGracefully();
        if (this.workerGroup != null) {
            this.workerGroup.shutdownGracefully();
        }
        if (this.businessGroup != null) {
            this.businessGroup.shutdown();
        }
        log.warn("==={}\u5df2\u7ecf\u505c\u6b62,port:{}===", (Object)this.config.name, (Object)this.config.port);
    }
}

