/*
 * Decompiled with CFR 0.152.
 */
package io.github.yedaxia.apidocs.parser;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.ArrayInitializerExpr;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MarkerAnnotationExpr;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import io.github.yedaxia.apidocs.ParseUtils;
import io.github.yedaxia.apidocs.Utils;
import io.github.yedaxia.apidocs.parser.AbsControllerParser;
import io.github.yedaxia.apidocs.parser.ClassNode;
import io.github.yedaxia.apidocs.parser.ControllerNode;
import io.github.yedaxia.apidocs.parser.HeaderNode;
import io.github.yedaxia.apidocs.parser.ParamNode;
import io.github.yedaxia.apidocs.parser.RequestMethod;
import io.github.yedaxia.apidocs.parser.RequestNode;
import io.github.yedaxia.apidocs.parser.ResponseNode;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class SpringControllerParser
extends AbsControllerParser {
    private static final String[] MAPPING_ANNOTATIONS = new String[]{"GetMapping", "PostMapping", "PutMapping", "PatchMapping", "DeleteMapping", "RequestMapping"};

    @Override
    protected void beforeHandleController(ControllerNode controllerNode, ClassOrInterfaceDeclaration clazz) {
        clazz.getAnnotationByName("RequestMapping").ifPresent(a -> {
            if (a instanceof SingleMemberAnnotationExpr) {
                String baseUrl = ((SingleMemberAnnotationExpr)a).getMemberValue().toString();
                controllerNode.setBaseUrl(Utils.removeQuotations(baseUrl));
                return;
            }
            if (a instanceof NormalAnnotationExpr) {
                ((NormalAnnotationExpr)a).getPairs().stream().filter(v -> this.isUrlPathKey(v.getNameAsString())).findFirst().ifPresent(p -> controllerNode.setBaseUrl(Utils.removeQuotations(p.getValue().toString())));
            }
        });
    }

    @Override
    protected void afterHandleMethod(RequestNode requestNode, MethodDeclaration md) {
        md.getAnnotations().forEach(an -> {
            String name = an.getNameAsString();
            if (Arrays.asList(MAPPING_ANNOTATIONS).contains(name)) {
                String method = Utils.getClassName(name).toUpperCase().replace("MAPPING", "");
                if (!"REQUEST".equals(method)) {
                    requestNode.addMethod(RequestMethod.valueOf(method).name());
                }
                if (an instanceof NormalAnnotationExpr) {
                    ((NormalAnnotationExpr)an).getPairs().forEach(p -> {
                        NodeList values;
                        Expression methodAttr;
                        String key = p.getNameAsString();
                        if (this.isUrlPathKey(key)) {
                            requestNode.setUrl(Utils.removeQuotations(p.getValue().toString()));
                        }
                        if ("headers".equals(key)) {
                            methodAttr = p.getValue();
                            if (methodAttr instanceof ArrayInitializerExpr) {
                                values = ((ArrayInitializerExpr)methodAttr).getValues();
                                for (Node n : values) {
                                    String[] h = n.toString().split("=");
                                    requestNode.addHeaderNode(new HeaderNode(h[0], h[1]));
                                }
                            } else {
                                String[] h = p.getValue().toString().split("=");
                                requestNode.addHeaderNode(new HeaderNode(h[0], h[1]));
                            }
                        }
                        if ("method".equals(key)) {
                            methodAttr = p.getValue();
                            if (methodAttr instanceof ArrayInitializerExpr) {
                                values = ((ArrayInitializerExpr)methodAttr).getValues();
                                for (Node n : values) {
                                    requestNode.addMethod(RequestMethod.valueOf(Utils.getClassName(n.toString())).name());
                                }
                            } else {
                                requestNode.addMethod(RequestMethod.valueOf(Utils.getClassName(p.getValue().toString())).name());
                            }
                        }
                    });
                }
                if (an instanceof SingleMemberAnnotationExpr) {
                    String url = ((SingleMemberAnnotationExpr)an).getMemberValue().toString();
                    requestNode.setUrl(Utils.removeQuotations(url));
                }
                requestNode.setUrl(Utils.getActionUrl(this.getControllerNode().getBaseUrl(), requestNode.getUrl()));
            }
        });
        md.getParameters().forEach(p -> {
            String paraName = p.getName().asString();
            ParamNode paramNode = requestNode.getParamNodeByName(paraName);
            if (paramNode != null) {
                p.getAnnotations().forEach(an -> {
                    String name = an.getNameAsString();
                    if (ParseUtils.isNotNullAnnotation(name)) {
                        paramNode.setRequired(true);
                        return;
                    }
                    if (!("RequestParam".equals(name) || "RequestBody".equals(name) || "PathVariable".equals(name))) {
                        return;
                    }
                    if ("RequestBody".equals(name)) {
                        this.setRequestBody(paramNode, p.getType());
                    }
                    if (an instanceof MarkerAnnotationExpr) {
                        paramNode.setRequired(true);
                        return;
                    }
                    if (an instanceof SingleMemberAnnotationExpr) {
                        paramNode.setName(((StringLiteralExpr)((SingleMemberAnnotationExpr)an).getMemberValue()).getValue());
                        return;
                    }
                    if (an instanceof NormalAnnotationExpr) {
                        ((NormalAnnotationExpr)an).getPairs().forEach(pair -> {
                            String exprName = pair.getNameAsString();
                            if ("required".equals(exprName)) {
                                Boolean exprValue = ((BooleanLiteralExpr)pair.getValue()).getValue();
                                paramNode.setRequired(exprValue);
                            } else if ("value".equals(exprName)) {
                                String exprValue = ((StringLiteralExpr)pair.getValue()).getValue();
                                paramNode.setName(exprValue);
                            }
                        });
                    }
                });
                if (!paramNode.isJsonBody() && ParseUtils.isModelType(paramNode.getType())) {
                    ClassNode classNode = new ClassNode();
                    ParseUtils.parseClassNodeByType(this.getControllerFile(), classNode, p.getType());
                    ArrayList<ParamNode> paramNodeList = new ArrayList<ParamNode>();
                    this.toParamNodeList(paramNodeList, classNode, "");
                    requestNode.getParamNodes().remove(paramNode);
                    requestNode.getParamNodes().addAll(paramNodeList);
                }
            }
        });
    }

    @Override
    protected void handleResponseNode(ResponseNode responseNode, Type resultType, File controllerFile) {
        String className;
        if (resultType instanceof ClassOrInterfaceType && "org.springframework.http.ResponseEntity".endsWith(className = ((ClassOrInterfaceType)resultType).getName().getIdentifier())) {
            Optional nodeListOptional = ((ClassOrInterfaceType)resultType).getTypeArguments();
            if (nodeListOptional.isPresent()) {
                NodeList typeNodeList = (NodeList)nodeListOptional.get();
                if (!typeNodeList.isEmpty()) {
                    resultType = ((Type)typeNodeList.get(0)).getElementType();
                }
            } else {
                responseNode.setClassName(className);
                return;
            }
        }
        super.handleResponseNode(responseNode, resultType, controllerFile);
    }

    private void setRequestBody(ParamNode paramNode, Type paramType) {
        if (ParseUtils.isModelType(paramType.asString())) {
            ClassNode classNode = new ClassNode();
            ParseUtils.parseClassNodeByType(this.getControllerFile(), classNode, paramType);
            paramNode.setJsonBody(true);
            classNode.setShowFieldNotNull(Boolean.TRUE);
            paramNode.setDescription(classNode.toJsonApi());
        }
    }

    private void toParamNodeList(List<ParamNode> paramNodeList, ClassNode formNode, String parentName) {
        formNode.getChildNodes().forEach(filedNode -> {
            if (filedNode.getChildNode() != null) {
                this.toParamNodeList(paramNodeList, filedNode.getChildNode(), filedNode.getName() + ".");
            } else {
                ParamNode paramNode = new ParamNode();
                paramNode.setName(parentName + filedNode.getName());
                paramNode.setType(filedNode.getType());
                paramNode.setDescription(filedNode.getDescription());
                paramNode.setRequired(filedNode.getNotNull());
                paramNodeList.add(paramNode);
            }
        });
    }

    private boolean isUrlPathKey(String name) {
        return name.equals("path") || name.equals("value");
    }
}

