/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.driver.sdk.service.rabbit;

import cn.hutool.core.util.ObjectUtil;
import com.rabbitmq.client.Channel;
import io.github.pnoker.common.dto.DriverMetadataDTO;
import io.github.pnoker.common.utils.JsonUtil;
import io.github.pnoker.driver.sdk.service.DriverMetadataService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.stereotype.Component;

@Component
public class DriverMetadataReceiver {
    private static final Logger log = LoggerFactory.getLogger(DriverMetadataReceiver.class);
    @Resource
    private DriverMetadataService driverMetadataService;

    @RabbitHandler
    @RabbitListener(queues={"#{driverMetadataQueue.name}"})
    public void driverMetadataReceive(Channel channel, Message message, DriverMetadataDTO entityDTO) {
        try {
            channel.basicAck(message.getMessageProperties().getDeliveryTag(), true);
            log.debug("Receive driver metadata: {}", (Object)JsonUtil.toPrettyJsonString((Object)entityDTO));
            if (ObjectUtil.isNull((Object)entityDTO) || ObjectUtil.isNull((Object)entityDTO.getType()) || ObjectUtil.isNull((Object)entityDTO.getMetadataCommandType())) {
                log.error("Invalid driver metadata: {}", (Object)entityDTO);
                return;
            }
            switch (entityDTO.getType()) {
                case PROFILE: {
                    this.driverMetadataService.profileMetadata(entityDTO);
                    break;
                }
                case POINT: {
                    this.driverMetadataService.pointMetadata(entityDTO);
                    break;
                }
                case DEVICE: {
                    this.driverMetadataService.deviceMetadata(entityDTO);
                    break;
                }
                case DRIVER_ATTRIBUTE_CONFIG: {
                    this.driverMetadataService.driverInfoMetadata(entityDTO);
                    break;
                }
                case POINT_ATTRIBUTE_CONFIG: {
                    this.driverMetadataService.pointInfoMetadata(entityDTO);
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

