/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.driver.sdk.service.job;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import io.github.pnoker.common.model.Device;
import io.github.pnoker.driver.sdk.DriverContext;
import io.github.pnoker.driver.sdk.service.DriverCommandService;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.Resource;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.stereotype.Component;

@Component
public class DriverReadScheduleJob
extends QuartzJobBean {
    private static final Logger log = LoggerFactory.getLogger(DriverReadScheduleJob.class);
    @Resource
    private DriverContext driverContext;
    @Resource
    private ThreadPoolExecutor threadPoolExecutor;
    @Resource
    private DriverCommandService driverCommandService;

    protected void executeInternal(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        Map deviceMap = this.driverContext.getDriverMetadata().getDeviceMap();
        if (ObjectUtil.isNull((Object)deviceMap)) {
            return;
        }
        for (Device device : deviceMap.values()) {
            Set profileIds = device.getProfileIds();
            Map pointInfoMap = (Map)this.driverContext.getDriverMetadata().getPointInfoMap().get(device.getId());
            if (CollUtil.isEmpty((Collection)profileIds) || ObjectUtil.isNull((Object)pointInfoMap)) continue;
            for (String profileId : profileIds) {
                Map pointMap = (Map)this.driverContext.getDriverMetadata().getProfilePointMap().get(profileId);
                if (ObjectUtil.isNull((Object)pointMap)) continue;
                for (String pointId : pointMap.keySet()) {
                    Map map = (Map)pointInfoMap.get(pointId);
                    if (ObjectUtil.isNull((Object)map)) continue;
                    this.threadPoolExecutor.execute(() -> this.driverCommandService.read(device.getId(), pointId));
                }
            }
        }
    }
}

