/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.driver.sdk.service.impl;

import cn.hutool.core.util.ObjectUtil;
import io.github.pnoker.common.constant.driver.RabbitConstant;
import io.github.pnoker.common.dto.DriverEventDTO;
import io.github.pnoker.common.entity.DeviceEvent;
import io.github.pnoker.common.entity.point.PointValue;
import io.github.pnoker.common.enums.DeviceStatusEnum;
import io.github.pnoker.common.utils.JsonUtil;
import io.github.pnoker.driver.sdk.entity.property.DriverProperty;
import io.github.pnoker.driver.sdk.service.DriverSenderService;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.stereotype.Service;

@Service
public class DriverSenderServiceImpl
implements DriverSenderService {
    private static final Logger log = LoggerFactory.getLogger(DriverSenderServiceImpl.class);
    @Resource
    private DriverProperty driverProperty;
    @Resource
    private RabbitTemplate rabbitTemplate;

    @Override
    public void driverEventSender(DriverEventDTO entityDTO) {
        if (ObjectUtil.isNull((Object)entityDTO)) {
            return;
        }
        this.rabbitTemplate.convertAndSend(RabbitConstant.TOPIC_EXCHANGE_EVENT, "dc3.r.event.driver." + this.driverProperty.getService(), (Object)entityDTO);
    }

    @Override
    public void deviceEventSender(DeviceEvent deviceEvent) {
        if (ObjectUtil.isNotNull((Object)deviceEvent)) {
            this.rabbitTemplate.convertAndSend(RabbitConstant.TOPIC_EXCHANGE_EVENT, "dc3.r.event.device." + this.driverProperty.getService(), (Object)deviceEvent);
        }
    }

    @Override
    public void deviceStatusSender(String deviceId, DeviceStatusEnum status) {
        this.deviceEventSender(new DeviceEvent(deviceId, "device_status", (Object)status));
    }

    @Override
    public void pointValueSender(PointValue pointValue) {
        if (ObjectUtil.isNotNull((Object)pointValue)) {
            log.debug("Send point value: {}", (Object)JsonUtil.toJsonString((Object)pointValue));
            this.rabbitTemplate.convertAndSend(RabbitConstant.TOPIC_EXCHANGE_VALUE, "dc3.r.value.point." + this.driverProperty.getService(), (Object)pointValue);
        }
    }

    @Override
    public void pointValueSender(List<PointValue> pointValues) {
        if (ObjectUtil.isNotNull(pointValues)) {
            pointValues.forEach(this::pointValueSender);
        }
    }
}

