/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.driver.sdk.service.impl;

import cn.hutool.core.util.ObjectUtil;
import io.github.pnoker.driver.sdk.entity.property.DriverProperty;
import io.github.pnoker.driver.sdk.entity.property.ScheduleProperty;
import io.github.pnoker.driver.sdk.service.DriverScheduleService;
import io.github.pnoker.driver.sdk.service.job.DriverCustomScheduleJob;
import io.github.pnoker.driver.sdk.service.job.DriverReadScheduleJob;
import io.github.pnoker.driver.sdk.service.job.DriverStatusScheduleJob;
import javax.annotation.Resource;
import org.quartz.CronScheduleBuilder;
import org.quartz.DateBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DriverScheduleServiceImpl
implements DriverScheduleService {
    private static final Logger log = LoggerFactory.getLogger(DriverScheduleServiceImpl.class);
    @Resource
    private Scheduler scheduler;
    @Resource
    private DriverProperty driverProperty;

    @Override
    public void initial() {
        ScheduleProperty property = this.driverProperty.getSchedule();
        if (ObjectUtil.isNull((Object)property)) {
            return;
        }
        if (Boolean.TRUE.equals(property.getRead().getEnable())) {
            this.createScheduleJobWithCorn("DriverScheduleGroup", "ReadScheduleJob", property.getRead().getCorn(), DriverReadScheduleJob.class);
        }
        if (Boolean.TRUE.equals(property.getCustom().getEnable())) {
            this.createScheduleJobWithCorn("DriverScheduleGroup", "CustomScheduleJob", property.getCustom().getCorn(), DriverCustomScheduleJob.class);
        }
        this.createScheduleJobWithCorn("DriverScheduleGroup", "StatusScheduleJob", "0/5 * * * * ?", DriverStatusScheduleJob.class);
        try {
            if (!this.scheduler.isShutdown()) {
                this.scheduler.start();
            }
        }
        catch (SchedulerException e) {
            log.error("Driver schedule initial error: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void createScheduleJobWithCorn(String group, String name, String corn, Class<? extends Job> jobClass) {
        JobDetail jobDetail = JobBuilder.newJob(jobClass).withIdentity(name, group).build();
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(name, group).startAt(DateBuilder.futureDate((int)1, (DateBuilder.IntervalUnit)DateBuilder.IntervalUnit.SECOND)).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)corn)).startNow().build();
        this.scheduler.scheduleJob(jobDetail, trigger);
    }
}

