/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.driver.sdk.service.impl;

import cn.hutool.core.util.ObjectUtil;
import io.github.pnoker.common.entity.driver.AttributeInfo;
import io.github.pnoker.common.model.Device;
import io.github.pnoker.common.model.DriverAttribute;
import io.github.pnoker.common.model.DriverAttributeConfig;
import io.github.pnoker.common.model.Point;
import io.github.pnoker.common.model.PointAttribute;
import io.github.pnoker.common.model.PointAttributeConfig;
import io.github.pnoker.common.model.Profile;
import io.github.pnoker.driver.sdk.DriverContext;
import io.github.pnoker.driver.sdk.service.DriverMetadataTempService;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DriverMetadataTempServiceImpl
implements DriverMetadataTempService {
    private static final Logger log = LoggerFactory.getLogger(DriverMetadataTempServiceImpl.class);
    @Resource
    private DriverContext driverContext;

    @Override
    public void upsertProfile(Profile profile) {
        this.driverContext.getDriverMetadata().getProfilePointMap().computeIfAbsent(profile.getId(), k -> new ConcurrentHashMap(16));
    }

    @Override
    public void deleteProfile(String id) {
        this.driverContext.getDriverMetadata().getProfilePointMap().entrySet().removeIf(next -> ((String)next.getKey()).equals(id));
    }

    @Override
    public void upsertDevice(Device device) {
        this.driverContext.getDriverMetadata().getDeviceMap().put(device.getId(), device);
        this.driverContext.getDriverMetadata().getDriverInfoMap().computeIfAbsent(device.getId(), k -> new ConcurrentHashMap(16));
        this.driverContext.getDriverMetadata().getPointInfoMap().computeIfAbsent(device.getId(), k -> new ConcurrentHashMap(16));
    }

    @Override
    public void deleteDevice(String id) {
        this.driverContext.getDriverMetadata().getDeviceMap().entrySet().removeIf(next -> ((String)next.getKey()).equals(id));
        this.driverContext.getDriverMetadata().getDriverInfoMap().entrySet().removeIf(next -> ((String)next.getKey()).equals(id));
        this.driverContext.getDriverMetadata().getPointInfoMap().entrySet().removeIf(next -> ((String)next.getKey()).equals(id));
    }

    @Override
    public void upsertPoint(Point point) {
        this.driverContext.getDriverMetadata().getProfilePointMap().computeIfAbsent(point.getProfileId(), k -> new ConcurrentHashMap(16)).put(point.getId(), point);
    }

    @Override
    public void deletePoint(String profileId, String pointId) {
        this.driverContext.getDriverMetadata().getProfilePointMap().computeIfPresent(profileId, (k, v) -> {
            v.entrySet().removeIf(next -> ((String)next.getKey()).equals(pointId));
            return v;
        });
    }

    @Override
    public void upsertDriverInfo(DriverAttributeConfig driverAttributeConfig) {
        DriverAttribute attribute = (DriverAttribute)this.driverContext.getDriverMetadata().getDriverAttributeMap().get(driverAttributeConfig.getDriverAttributeId());
        if (ObjectUtil.isNotNull((Object)attribute)) {
            this.driverContext.getDriverMetadata().getDriverInfoMap().computeIfAbsent(driverAttributeConfig.getDeviceId(), k -> new ConcurrentHashMap(16)).put(attribute.getAttributeName(), new AttributeInfo(driverAttributeConfig.getConfigValue(), attribute.getAttributeTypeFlag()));
        }
    }

    @Override
    public void deleteDriverInfo(String deviceId, String attributeId) {
        DriverAttribute attribute = (DriverAttribute)this.driverContext.getDriverMetadata().getDriverAttributeMap().get(attributeId);
        if (ObjectUtil.isNotNull((Object)attribute)) {
            this.driverContext.getDriverMetadata().getDriverInfoMap().computeIfPresent(deviceId, (k, v) -> {
                v.entrySet().removeIf(next -> ((String)next.getKey()).equals(attribute.getAttributeName()));
                return v;
            });
            this.driverContext.getDriverMetadata().getDriverInfoMap().entrySet().removeIf(next -> ((Map)next.getValue()).size() < 1);
        }
    }

    @Override
    public void upsertPointInfo(PointAttributeConfig pointAttributeConfig) {
        PointAttribute attribute = (PointAttribute)this.driverContext.getDriverMetadata().getPointAttributeMap().get(pointAttributeConfig.getPointAttributeId());
        if (ObjectUtil.isNotNull((Object)attribute)) {
            this.driverContext.getDriverMetadata().getPointInfoMap().computeIfAbsent(pointAttributeConfig.getDeviceId(), k -> new ConcurrentHashMap(16)).computeIfAbsent(pointAttributeConfig.getPointId(), k -> new ConcurrentHashMap(16)).put(attribute.getAttributeName(), new AttributeInfo(pointAttributeConfig.getConfigValue(), attribute.getAttributeTypeFlag()));
        }
    }

    @Override
    public void deletePointInfo(String deviceId, String pointId, String attributeId) {
        PointAttribute attribute = (PointAttribute)this.driverContext.getDriverMetadata().getPointAttributeMap().get(attributeId);
        if (ObjectUtil.isNotNull((Object)attribute)) {
            this.driverContext.getDriverMetadata().getPointInfoMap().computeIfPresent(deviceId, (key1, value1) -> {
                value1.computeIfPresent(pointId, (key2, value2) -> {
                    value2.entrySet().removeIf(next -> ((String)next.getKey()).equals(attribute.getAttributeName()));
                    return value2;
                });
                return value1;
            });
            this.driverContext.getDriverMetadata().getPointInfoMap().computeIfPresent(deviceId, (key, value) -> {
                value.entrySet().removeIf(next -> ((Map)next.getValue()).size() < 1);
                return value;
            });
        }
    }
}

