/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.driver.sdk.service.impl;

import io.github.pnoker.common.dto.DriverMetadataDTO;
import io.github.pnoker.common.enums.MetadataCommandTypeEnum;
import io.github.pnoker.common.model.Device;
import io.github.pnoker.common.model.DriverAttributeConfig;
import io.github.pnoker.common.model.Point;
import io.github.pnoker.common.model.PointAttributeConfig;
import io.github.pnoker.common.model.Profile;
import io.github.pnoker.common.utils.JsonUtil;
import io.github.pnoker.driver.sdk.service.DriverMetadataService;
import io.github.pnoker.driver.sdk.service.DriverMetadataTempService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DriverMetadataServiceImpl
implements DriverMetadataService {
    private static final Logger log = LoggerFactory.getLogger(DriverMetadataServiceImpl.class);
    @Resource
    private DriverMetadataTempService driverMetadataTempService;

    @Override
    public void profileMetadata(DriverMetadataDTO entityDTO) {
        Profile profile = (Profile)JsonUtil.parseObject((String)entityDTO.getContent(), Profile.class);
        if (MetadataCommandTypeEnum.ADD.equals((Object)entityDTO.getMetadataCommandType()) || MetadataCommandTypeEnum.UPDATE.equals((Object)entityDTO.getMetadataCommandType())) {
            log.info("Upsert profile: {}", (Object)JsonUtil.toJsonString((Object)profile));
            this.driverMetadataTempService.upsertProfile(profile);
        } else if (MetadataCommandTypeEnum.DELETE.equals((Object)entityDTO.getMetadataCommandType())) {
            log.info("Delete profile: {}", (Object)JsonUtil.toJsonString((Object)profile));
            this.driverMetadataTempService.deleteProfile(profile.getId());
        }
    }

    @Override
    public void deviceMetadata(DriverMetadataDTO entityDTO) {
        Device device = (Device)JsonUtil.parseObject((String)entityDTO.getContent(), Device.class);
        if (MetadataCommandTypeEnum.ADD.equals((Object)entityDTO.getMetadataCommandType()) || MetadataCommandTypeEnum.UPDATE.equals((Object)entityDTO.getMetadataCommandType())) {
            log.info("Upsert device: {}", (Object)JsonUtil.toJsonString((Object)device));
            this.driverMetadataTempService.upsertDevice(device);
        } else if (MetadataCommandTypeEnum.DELETE.equals((Object)entityDTO.getMetadataCommandType())) {
            log.info("Delete device: {}", (Object)JsonUtil.toJsonString((Object)device));
            this.driverMetadataTempService.deleteDevice(device.getId());
        }
    }

    @Override
    public void pointMetadata(DriverMetadataDTO entityDTO) {
        Point point = (Point)JsonUtil.parseObject((String)entityDTO.getContent(), Point.class);
        if (MetadataCommandTypeEnum.ADD.equals((Object)entityDTO.getMetadataCommandType()) || MetadataCommandTypeEnum.UPDATE.equals((Object)entityDTO.getMetadataCommandType())) {
            log.info("Upsert point: {}", (Object)JsonUtil.toJsonString((Object)point));
            this.driverMetadataTempService.upsertPoint(point);
        } else if (MetadataCommandTypeEnum.DELETE.equals((Object)entityDTO.getMetadataCommandType())) {
            log.info("Delete point: {}", (Object)JsonUtil.toJsonString((Object)point));
            this.driverMetadataTempService.deletePoint(point.getProfileId(), point.getId());
        }
    }

    @Override
    public void driverInfoMetadata(DriverMetadataDTO entityDTO) {
        DriverAttributeConfig driverAttributeConfig = (DriverAttributeConfig)JsonUtil.parseObject((String)entityDTO.getContent(), DriverAttributeConfig.class);
        if (MetadataCommandTypeEnum.ADD.equals((Object)entityDTO.getMetadataCommandType()) || MetadataCommandTypeEnum.UPDATE.equals((Object)entityDTO.getMetadataCommandType())) {
            log.info("Upsert driver attribute config: {}", (Object)JsonUtil.toJsonString((Object)driverAttributeConfig));
            this.driverMetadataTempService.upsertDriverInfo(driverAttributeConfig);
        } else if (MetadataCommandTypeEnum.DELETE.equals((Object)entityDTO.getMetadataCommandType())) {
            log.info("Delete driver attribute config: {}", (Object)JsonUtil.toJsonString((Object)driverAttributeConfig));
            this.driverMetadataTempService.deleteDriverInfo(driverAttributeConfig.getDeviceId(), driverAttributeConfig.getDriverAttributeId());
        }
    }

    @Override
    public void pointInfoMetadata(DriverMetadataDTO entityDTO) {
        PointAttributeConfig pointAttributeConfig = (PointAttributeConfig)JsonUtil.parseObject((String)entityDTO.getContent(), PointAttributeConfig.class);
        if (MetadataCommandTypeEnum.ADD.equals((Object)entityDTO.getMetadataCommandType()) || MetadataCommandTypeEnum.UPDATE.equals((Object)entityDTO.getMetadataCommandType())) {
            log.info("Upsert point attribute config: {}", (Object)JsonUtil.toJsonString((Object)pointAttributeConfig));
            this.driverMetadataTempService.upsertPointInfo(pointAttributeConfig);
        } else if (MetadataCommandTypeEnum.DELETE.equals((Object)entityDTO.getMetadataCommandType())) {
            log.info("Delete point attribute config: {}", (Object)JsonUtil.toJsonString((Object)pointAttributeConfig));
            this.driverMetadataTempService.deletePointInfo(pointAttributeConfig.getPointId(), pointAttributeConfig.getId(), pointAttributeConfig.getPointAttributeId());
        }
    }
}

