/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.driver.sdk.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import io.github.pnoker.common.dto.DeviceCommandDTO;
import io.github.pnoker.common.entity.driver.AttributeInfo;
import io.github.pnoker.common.entity.point.PointValue;
import io.github.pnoker.common.enums.AttributeTypeFlagEnum;
import io.github.pnoker.common.exception.ReadPointException;
import io.github.pnoker.common.exception.ServiceException;
import io.github.pnoker.common.model.Device;
import io.github.pnoker.common.model.Point;
import io.github.pnoker.common.utils.JsonUtil;
import io.github.pnoker.driver.sdk.DriverContext;
import io.github.pnoker.driver.sdk.service.DriverCommandService;
import io.github.pnoker.driver.sdk.service.DriverCustomService;
import io.github.pnoker.driver.sdk.service.DriverSenderService;
import io.github.pnoker.driver.sdk.utils.ConvertUtil;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DriverCommandServiceImpl
implements DriverCommandService {
    private static final Logger log = LoggerFactory.getLogger(DriverCommandServiceImpl.class);
    @Resource
    private DriverContext driverContext;
    @Resource
    private DriverSenderService driverSenderService;
    @Resource
    private DriverCustomService driverCustomService;

    @Override
    public PointValue read(String deviceId, String pointId) {
        Device device = this.driverContext.getDeviceByDeviceId(deviceId);
        Point point = this.driverContext.getPointByDeviceIdAndPointId(deviceId, pointId);
        try {
            String rawValue = this.driverCustomService.read(this.driverContext.getDriverInfoByDeviceId(deviceId), this.driverContext.getPointInfoByDeviceIdAndPointId(deviceId, pointId), device, this.driverContext.getPointByDeviceIdAndPointId(deviceId, pointId));
            if (CharSequenceUtil.isEmpty((CharSequence)rawValue)) {
                throw new ReadPointException((CharSequence)"The read point value is null", new Object[0]);
            }
            if ("nil".equals(rawValue)) {
                throw new ReadPointException((CharSequence)CharSequenceUtil.format((CharSequence)"The read point value is invalid: {}", (Object[])new Object[]{rawValue}), new Object[0]);
            }
            PointValue pointValue = new PointValue(deviceId, pointId, rawValue, ConvertUtil.convertValue(point, rawValue));
            this.driverSenderService.pointValueSender(pointValue);
            return pointValue;
        }
        catch (Exception e) {
            throw new ServiceException((CharSequence)e.getMessage(), new Object[]{e});
        }
    }

    @Override
    public void read(DeviceCommandDTO commandDTO) {
        DeviceCommandDTO.DeviceRead deviceRead = (DeviceCommandDTO.DeviceRead)JsonUtil.parseObject((String)commandDTO.getContent(), DeviceCommandDTO.DeviceRead.class);
        if (ObjectUtil.isNull((Object)deviceRead)) {
            return;
        }
        log.info("Start command of read: {}", (Object)JsonUtil.toPrettyJsonString((Object)commandDTO));
        PointValue read = this.read(deviceRead.getDeviceId(), deviceRead.getPointId());
        log.info("End command of read: {}", (Object)JsonUtil.toPrettyJsonString((Object)read));
    }

    @Override
    public Boolean write(String deviceId, String pointId, String value) {
        Device device = this.driverContext.getDeviceByDeviceId(deviceId);
        try {
            Point point = this.driverContext.getPointByDeviceIdAndPointId(deviceId, pointId);
            AttributeTypeFlagEnum typeEnum = AttributeTypeFlagEnum.ofCode((String)point.getPointTypeFlag().getCode());
            return this.driverCustomService.write(this.driverContext.getDriverInfoByDeviceId(deviceId), this.driverContext.getPointInfoByDeviceIdAndPointId(deviceId, pointId), device, new AttributeInfo(value, typeEnum));
        }
        catch (Exception e) {
            throw new ServiceException((CharSequence)e.getMessage(), new Object[0]);
        }
    }

    @Override
    public void write(DeviceCommandDTO commandDTO) {
        DeviceCommandDTO.DeviceWrite deviceWrite = (DeviceCommandDTO.DeviceWrite)JsonUtil.parseObject((String)commandDTO.getContent(), DeviceCommandDTO.DeviceWrite.class);
        if (ObjectUtil.isNull((Object)deviceWrite)) {
            return;
        }
        log.info("Start command of write: {}", (Object)JsonUtil.toPrettyJsonString((Object)commandDTO));
        Boolean write = this.write(deviceWrite.getDeviceId(), deviceWrite.getPointId(), deviceWrite.getValue());
        log.info("End command of write: write {}", (Object)write);
    }
}

