/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.driver.sdk.config;

import cn.hutool.core.text.CharSequenceUtil;
import io.github.pnoker.common.utils.EnvironmentUtil;
import io.github.pnoker.common.utils.HostUtil;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

@Configuration
@Order(value=2147483547)
public class DriverEnvironmentConfig
implements EnvironmentPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(DriverEnvironmentConfig.class);

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        String node = (String)environment.getProperty("driver.node", String.class);
        if (CharSequenceUtil.isEmpty((CharSequence)node)) {
            node = EnvironmentUtil.getNodeId();
        }
        String tenant = (String)environment.getProperty("driver.tenant", String.class);
        String name = (String)environment.getProperty("spring.application.name", String.class);
        String client = CharSequenceUtil.format((CharSequence)"{}/{}_{}", (Object[])new Object[]{tenant, name, node});
        String service = CharSequenceUtil.format((CharSequence)"{}/{}", (Object[])new Object[]{tenant, name});
        HashMap<String, String> source = new HashMap<String, String>(2);
        source.put("driver.node", node);
        source.put("driver.service", service);
        source.put("driver.host", HostUtil.localHost());
        source.put("driver.client", client);
        MutablePropertySources propertySources = environment.getPropertySources();
        propertySources.addFirst((PropertySource)new MapPropertySource("driver", source));
    }
}

