/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.driver.sdk;

import cn.hutool.core.util.ObjectUtil;
import io.github.pnoker.common.entity.driver.AttributeInfo;
import io.github.pnoker.common.entity.driver.DriverMetadata;
import io.github.pnoker.common.enums.DriverStatusEnum;
import io.github.pnoker.common.exception.NotFoundException;
import io.github.pnoker.common.model.Device;
import io.github.pnoker.common.model.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DriverContext {
    private static final Logger log = LoggerFactory.getLogger(DriverContext.class);
    private DriverStatusEnum driverStatus = DriverStatusEnum.OFFLINE;
    private DriverMetadata driverMetadata = new DriverMetadata();

    public Map<String, AttributeInfo> getDriverInfoByDeviceId(String deviceId) {
        return (Map)this.driverMetadata.getDriverInfoMap().get(deviceId);
    }

    public Map<String, Map<String, AttributeInfo>> getPointInfoByDeviceId(String deviceId) {
        Map tmpMap = (Map)this.driverMetadata.getPointInfoMap().get(deviceId);
        if (ObjectUtil.isNull((Object)tmpMap) || tmpMap.size() < 1) {
            throw new NotFoundException((CharSequence)"Device({}) does not exist", new Object[]{deviceId});
        }
        return tmpMap;
    }

    public Map<String, AttributeInfo> getPointInfoByDeviceIdAndPointId(String deviceId, String pointId) {
        Map<String, AttributeInfo> tmpMap = this.getPointInfoByDeviceId(deviceId).get(pointId);
        if (ObjectUtil.isNull(tmpMap) || tmpMap.size() < 1) {
            throw new NotFoundException((CharSequence)"Point({}) info does not exist", new Object[]{pointId});
        }
        return tmpMap;
    }

    public Device getDeviceByDeviceId(String deviceId) {
        Device device = (Device)this.driverMetadata.getDeviceMap().get(deviceId);
        if (ObjectUtil.isNull((Object)device)) {
            throw new NotFoundException((CharSequence)"Device({}) does not exist", new Object[]{deviceId});
        }
        return device;
    }

    public List<Point> getPointByDeviceId(String deviceId) {
        Device device = this.getDeviceByDeviceId(deviceId);
        return this.driverMetadata.getProfilePointMap().entrySet().stream().filter(entry -> device.getProfileIds().contains(entry.getKey())).map(entry -> new ArrayList(((Map)entry.getValue()).values())).reduce(new ArrayList(), (total, temp) -> {
            total.addAll(temp);
            return total;
        });
    }

    public Point getPointByDeviceIdAndPointId(String deviceId, String pointId) {
        Device device = this.getDeviceByDeviceId(deviceId);
        Optional<Map> optional = this.driverMetadata.getProfilePointMap().entrySet().stream().filter(entry -> device.getProfileIds().contains(entry.getKey())).map(Map.Entry::getValue).filter(entry -> entry.containsKey(pointId)).findFirst();
        if (optional.isPresent()) {
            return (Point)optional.get().get(pointId);
        }
        throw new NotFoundException((CharSequence)"Point({}) info does not exist", new Object[]{pointId});
    }

    public DriverStatusEnum getDriverStatus() {
        return this.driverStatus;
    }

    public DriverMetadata getDriverMetadata() {
        return this.driverMetadata;
    }

    public void setDriverStatus(DriverStatusEnum driverStatus) {
        this.driverStatus = driverStatus;
    }

    public void setDriverMetadata(DriverMetadata driverMetadata) {
        this.driverMetadata = driverMetadata;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DriverContext)) {
            return false;
        }
        DriverContext other = (DriverContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DriverStatusEnum this$driverStatus = this.getDriverStatus();
        DriverStatusEnum other$driverStatus = other.getDriverStatus();
        if (this$driverStatus == null ? other$driverStatus != null : !this$driverStatus.equals(other$driverStatus)) {
            return false;
        }
        DriverMetadata this$driverMetadata = this.getDriverMetadata();
        DriverMetadata other$driverMetadata = other.getDriverMetadata();
        return !(this$driverMetadata == null ? other$driverMetadata != null : !this$driverMetadata.equals(other$driverMetadata));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DriverContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DriverStatusEnum $driverStatus = this.getDriverStatus();
        result = result * 59 + ($driverStatus == null ? 43 : $driverStatus.hashCode());
        DriverMetadata $driverMetadata = this.getDriverMetadata();
        result = result * 59 + ($driverMetadata == null ? 43 : $driverMetadata.hashCode());
        return result;
    }

    public String toString() {
        return "DriverContext(driverStatus=" + this.getDriverStatus() + ", driverMetadata=" + this.getDriverMetadata() + ")";
    }

    public DriverContext() {
    }

    public DriverContext(DriverStatusEnum driverStatus, DriverMetadata driverMetadata) {
        this.driverStatus = driverStatus;
        this.driverMetadata = driverMetadata;
    }
}

