/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.enums;

import java.util.Arrays;
import java.util.Optional;

public enum ResponseEnum {
    OK("R_200", "Success"),
    TOKEN_INVALID("R_20301", "Token invalid"),
    IP_INVALID("R_20302", "Ip invalid"),
    FAILURE("R_500", "Service exception"),
    NO_RESOURCE("R_404", "Resource does not exist"),
    OUT_RANGE("R_900", "Number out range");

    private final String code;
    private final String message;

    public static ResponseEnum ofCode(String code) {
        Optional<ResponseEnum> any = Arrays.stream(ResponseEnum.values()).filter(type -> type.getCode().equals(code)).findFirst();
        return any.orElse(null);
    }

    public static ResponseEnum ofName(String name) {
        try {
            return ResponseEnum.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    private ResponseEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }
}

