/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.enums;

import java.util.Arrays;
import java.util.Optional;

public enum DeviceStatusEnum {
    ONLINE("ONLINE", "\u5728\u7ebf"),
    OFFLINE("OFFLINE", "\u79bb\u7ebf"),
    MAINTAIN("MAINTAIN", "\u7ef4\u62a4"),
    FAULT("FAULT", "\u6545\u969c");

    private final String code;
    private final String remark;

    public static DeviceStatusEnum ofCode(String code) {
        Optional<DeviceStatusEnum> any = Arrays.stream(DeviceStatusEnum.values()).filter(type -> type.getCode().equals(code)).findFirst();
        return any.orElse(null);
    }

    public static DeviceStatusEnum ofName(String name) {
        try {
            return DeviceStatusEnum.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public String getCode() {
        return this.code;
    }

    public String getRemark() {
        return this.remark;
    }

    private DeviceStatusEnum(String code, String remark) {
        this.code = code;
        this.remark = remark;
    }
}

