/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import java.util.Arrays;
import java.util.Optional;

public enum ApiTypeFlagEnum {
    POST((byte)0, "post", "POST"),
    DELETE((byte)1, "delete", "DELETE"),
    PUT((byte)2, "put", "PUT"),
    GET((byte)3, "get", "GET");

    @EnumValue
    private final Byte index;
    private final String code;
    private final String remark;

    public static ApiTypeFlagEnum ofCode(String code) {
        Optional<ApiTypeFlagEnum> any = Arrays.stream(ApiTypeFlagEnum.values()).filter(type -> type.getCode().equals(code)).findFirst();
        return any.orElse(null);
    }

    public static ApiTypeFlagEnum ofName(String name) {
        try {
            return ApiTypeFlagEnum.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public Byte getIndex() {
        return this.index;
    }

    public String getCode() {
        return this.code;
    }

    public String getRemark() {
        return this.remark;
    }

    private ApiTypeFlagEnum(Byte index, String code, String remark) {
        this.index = index;
        this.code = code;
        this.remark = remark;
    }
}

