/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.aspect;

import cn.hutool.core.collection.CollUtil;
import io.github.pnoker.common.annotation.CheckPermission;
import io.github.pnoker.common.enums.AuthMode;
import io.github.pnoker.common.exception.UnAuthorizedException;
import io.github.pnoker.common.model.AuthUser;
import io.github.pnoker.common.utils.AuthUtil;
import java.util.Objects;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class CheckPermissionAspect {
    private static final Logger log = LoggerFactory.getLogger(CheckPermissionAspect.class);

    @Pointcut(value="@annotation(io.github.pnoker.common.annotation.CheckPermission)")
    public void permissionCut() {
    }

    @Before(value="permissionCut()")
    public void doBefore(JoinPoint point) throws Throwable {
        AuthUser authUser;
        MethodSignature methodSignature = (MethodSignature)point.getSignature();
        CheckPermission annotation = methodSignature.getMethod().getAnnotation(CheckPermission.class);
        if (this.checkRole(annotation, authUser = AuthUtil.getAuthUser()).booleanValue()) {
            return;
        }
        if (!this.checkResource(annotation, authUser).booleanValue()) {
            throw new UnAuthorizedException((CharSequence)"No access", new Object[0]);
        }
    }

    private Boolean checkRole(CheckPermission annotation, AuthUser authUser) {
        String[] requireRoles = annotation.role();
        if (Objects.isNull(requireRoles) || requireRoles.length == 0) {
            return Boolean.FALSE;
        }
        Set<String> roleCodeSet = authUser.getRoleCodeSet();
        if (CollUtil.isEmpty(roleCodeSet)) {
            return Boolean.FALSE;
        }
        if (roleCodeSet.contains("admin")) {
            return Boolean.TRUE;
        }
        if (AuthMode.AND.equals((Object)annotation.roleMode())) {
            return this.checkAndMode(requireRoles, roleCodeSet);
        }
        return this.checkOrMode(requireRoles, roleCodeSet);
    }

    private Boolean checkResource(CheckPermission annotation, AuthUser authUser) {
        String[] requireResources = annotation.value();
        if (Objects.isNull(requireResources) || requireResources.length == 0) {
            return Boolean.FALSE;
        }
        Set<String> resourceCodeSet = authUser.getResourceCodeSet();
        if (CollUtil.isEmpty(resourceCodeSet)) {
            return Boolean.FALSE;
        }
        if (AuthMode.AND.equals((Object)annotation.mode())) {
            return this.checkAndMode(requireResources, resourceCodeSet);
        }
        return this.checkOrMode(requireResources, resourceCodeSet);
    }

    private Boolean checkAndMode(String[] requirePermissions, Set<String> hasPermissions) {
        for (String requirePermission : requirePermissions) {
            if (hasPermissions.contains(requirePermission)) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Boolean checkOrMode(String[] requirePermissions, Set<String> hasPermissions) {
        for (String requirePermission : requirePermissions) {
            if (!hasPermissions.contains(requirePermission)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

