/*
 * Decompiled with CFR 0.152.
 */
package com.mzt.logapi.context;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class LogRecordContext {
    private static final InheritableThreadLocal<Deque<Map<String, Object>>> VARIABLE_MAP_STACK = new InheritableThreadLocal();
    private static final InheritableThreadLocal<Map<String, Object>> GLOBAL_VARIABLE_MAP = new InheritableThreadLocal();

    private LogRecordContext() {
        throw new IllegalStateException("Utility class");
    }

    public static void putVariable(String name, Object value) {
        Deque mapStack;
        if (VARIABLE_MAP_STACK.get() == null) {
            ArrayDeque stack = new ArrayDeque();
            VARIABLE_MAP_STACK.set(stack);
        }
        if ((mapStack = (Deque)VARIABLE_MAP_STACK.get()).isEmpty()) {
            ((Deque)VARIABLE_MAP_STACK.get()).push(new HashMap());
        }
        ((Map)((Deque)VARIABLE_MAP_STACK.get()).element()).put(name, value);
    }

    public static void putGlobalVariable(String name, Object value) {
        if (GLOBAL_VARIABLE_MAP.get() == null) {
            GLOBAL_VARIABLE_MAP.set(new HashMap());
        }
        ((Map)GLOBAL_VARIABLE_MAP.get()).put(name, value);
    }

    public static Object getVariable(String key) {
        Map variableMap = (Map)((Deque)VARIABLE_MAP_STACK.get()).peek();
        return variableMap == null ? null : variableMap.get(key);
    }

    public static Object getMethodOrGlobal(String key) {
        Map globalMap;
        Object result = null;
        Map variableMap = (Map)((Deque)VARIABLE_MAP_STACK.get()).peek();
        if (!CollectionUtils.isEmpty((Map)variableMap)) {
            Object v = variableMap.get(key);
            result = v;
            if (v != null) {
                return result;
            }
        }
        if (!CollectionUtils.isEmpty((Map)(globalMap = (Map)GLOBAL_VARIABLE_MAP.get()))) {
            return globalMap.get(key);
        }
        return result;
    }

    public static Map<String, Object> getVariables() {
        Deque mapStack = (Deque)VARIABLE_MAP_STACK.get();
        return (Map)mapStack.peek();
    }

    public static Map<String, Object> getGlobalVariableMap() {
        return (Map)GLOBAL_VARIABLE_MAP.get();
    }

    public static void clear() {
        if (VARIABLE_MAP_STACK.get() != null) {
            ((Deque)VARIABLE_MAP_STACK.get()).pop();
        }
        if (((Deque)VARIABLE_MAP_STACK.get()).peek() == null) {
            GLOBAL_VARIABLE_MAP.remove();
        }
    }

    public static void putEmptySpan() {
        Deque mapStack = (Deque)VARIABLE_MAP_STACK.get();
        if (mapStack == null) {
            ArrayDeque stack = new ArrayDeque();
            VARIABLE_MAP_STACK.set(stack);
        }
        ((Deque)VARIABLE_MAP_STACK.get()).push(new HashMap());
        if (GLOBAL_VARIABLE_MAP.get() == null) {
            GLOBAL_VARIABLE_MAP.set(new HashMap());
        }
    }
}

