/*
 * Decompiled with CFR 0.152.
 */
package cn.mirrorming.text2date.time;

import cn.mirrorming.text2date.number.ChineseNumbers;
import cn.mirrorming.text2date.time.Cycle;
import cn.mirrorming.text2date.time.Holiday2StringConverter;
import cn.mirrorming.text2date.time.TimeEntity;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TimeEntityRecognizer {
    private static final Logger log = LoggerFactory.getLogger(TimeEntityRecognizer.class);
    private static final TimeZone CHINA_TIME_ZONE = TimeZone.getTimeZone("Asia/Shanghai");
    private Pattern pattern;
    private List<String> regexList;
    private static final Pattern NUMBER_P = Pattern.compile("[\u4e00\u4e8c\u4e24\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341]+");
    private static final Pattern TIME_MODIFIER_PATTERN = Pattern.compile("(\u65e9|\u65e9\u6668|\u65e9\u4e0a|\u4e0a\u5348|\u4e2d\u5348|\u5348\u540e|\u4e0b\u5348|\u508d\u665a|\u665a\u4e0a|\u665a\u95f4|\u591c\u91cc|\u591c|\u51cc\u6668|\u6df1\u591c|pm|PM)");
    private static final Pattern YEAR_2_DIGIT_PATTERN = Pattern.compile("[0-9]{2}(?=\u5e74)");
    private static final Pattern YEAR_4_DIGIT_PATTERN = Pattern.compile("[0-9]?[0-9]{3}(?=\u5e74)");
    private static final Pattern MONTH_PATTERN = Pattern.compile("((?<!\\d))((10)|(11)|(12)|([1-9]))(?=\u6708)");
    private static final Pattern DAY_PATTERN = Pattern.compile("(((?<!\\d))([0-3][0-9]|[1-9])(?=(\u65e5|\u53f7)))|((?<=\u6708)([0-3][0-9]|[1-9])(?=(\u65e5|\u53f7))?)");
    private static final Pattern HOUR_PATTERN = Pattern.compile("(?<!(\u5468|\u661f\u671f))([0-2]?[0-9])(?=(\u70b9|\u65f6))");
    private static final Pattern EARLY_MORNING_PATTERN = Pattern.compile("\u51cc\u6668");
    private static final Pattern MORNING_PATTERN = Pattern.compile("(\u65e9\u4e0a|\u65e9\u6668)");
    private static final Pattern FORENOON_PATTERN = Pattern.compile("(\u4e0a\u5348)|(am)|(AM)");
    private static final Pattern NOON_PATTERN = Pattern.compile("(\u4e2d\u5348)|(\u5348\u95f4)");
    private static final Pattern AFTERNOON_PATTERN = Pattern.compile("(\u4e0b\u5348)|(\u5348\u540e)|(pm)|(PM)");
    private static final Pattern EVENING_PATTERN = Pattern.compile("(\u508d\u665a)");
    private static final Pattern NIGHT_PATTERN = Pattern.compile("(?<!\u508d)\u665a");
    private static final Pattern MINUTE_PATTERN = Pattern.compile("([0-5]?[0-9](?=\u5206(?!\u949f)))|((?<=((?<!(\u5468|\u661f\u671f|\\d))([0-2]?[0-9])(\u70b9|\u65f6)))[0-5]?[0-9](?!\u523b))");
    private static final Pattern ONE_QUARTER_PATTERN = Pattern.compile("(?<=[\u70b9\u65f6])[1\u4e00]\u523b(?!\u949f)");
    private static final Pattern TWO_QUARTER_PATTERN = Pattern.compile("(?<=[\u70b9\u65f6])\u534a");
    private static final Pattern THREE_QUARTER_PATTERN = Pattern.compile("(?<=[\u70b9\u65f6])[3\u4e09]\u523b(?!\u949f)");
    private static final Pattern SECOND_PATTERN = Pattern.compile("([0-5]?[0-9](?=\u79d2))|((?<=\u5206)[0-5]?[0-9])");
    private static final Pattern HOUR_MINUTE_SECOND_PATTERN = Pattern.compile("(?<!(\u5468|\u661f\u671f))([0-2]?[0-9]):[0-5]?[0-9]:[0-5]?[0-9]");
    private static final Pattern HOUR_MINUTE_PATTERN = Pattern.compile("(?<!(\u5468|\u661f\u671f))([0-2]?[0-9]):[0-5]?[0-9]");
    private static final Pattern DASH_YEAR_MONTH_DAY = Pattern.compile("[0-9]?[0-9]?[0-9]{2}-((10)|(11)|(12)|([1-9]))-((?<!\\d))([0-3][0-9]|[1-9])");
    private static final Pattern SLASH_YEAR_MONTH_DAY = Pattern.compile("((10)|(11)|(12)|([1-9]))/((?<!\\d))([0-3][0-9]|[1-9])/[0-9]?[0-9]?[0-9]{2}");
    private static final Pattern DOT_YEAR_MONTH_DAY = Pattern.compile("[0-9]?[0-9]?[0-9]{2}\\.((10)|(11)|(12)|([1-9]))\\.((?<!\\d))([0-3][0-9]|[1-9])");
    private static final Pattern HALF_AN_HOUR_BEFORE_PATTERN = Pattern.compile("(\\d?+(\u4e2a?+\u534a+\u4e2a?+(\u5c0f\u65f6|\u949f\u5934)[\u4ee5\u4e4b]?\u524d))");
    private static final Pattern HALF_AN_HOUR_AFTER_PATTERN = Pattern.compile("(\\d?+(\u4e2a?+\u534a+\u4e2a?+(\u5c0f\u65f6|\u949f\u5934)[\u4ee5\u4e4b]?\u540e))");
    private static final Pattern MINUTE_BEFORE_PATTERN = Pattern.compile("(\\d+(?=\u5206\u949f[\u4ee5\u4e4b]?\u524d))|((?<=\u63d0\u524d)\\d+(?=\u5206\u949f))");
    private static final Pattern MINUTE_AFTER_PATTERN = Pattern.compile("\\d+(?=\u5206\u949f[\u4ee5\u4e4b]?\u540e)");
    private static final Pattern HOURS_BEFORE_PATTERN = Pattern.compile("(\\d+(?=(\u4e2a)?\u5c0f\u65f6[\u4ee5\u4e4b]?\u524d))|((?<=\u63d0\u524d)\\d+(?=(\u4e2a)?\u5c0f\u65f6))");
    private static final Pattern HOURS_AFTER_PATTERN = Pattern.compile("\\d+(?=(\u4e2a)?\u5c0f\u65f6[\u4ee5\u4e4b]?\u540e)");
    private static final Pattern DAYS_BEFORE_PATTERN = Pattern.compile("(\\d+(?=\u5929[\u4ee5\u4e4b]?\u524d))|((?<=\u63d0\u524d)?\\d+(?=\u5929))");
    private static final Pattern DAYS_AFTER_PATTERN = Pattern.compile("\\d+(?=\u5929[\u4ee5\u4e4b]?\u540e)");
    private static final Pattern MONTH_BEFORE_PATTERN = Pattern.compile("\\d+(?=(\u4e2a)?\u6708[\u4ee5\u4e4b]?\u524d)");
    private static final Pattern MONTH_AFTER_PATTERN = Pattern.compile("\\d+(?=(\u4e2a)?\u6708[\u4ee5\u4e4b]?\u540e)");
    private static final Pattern YEAR_BEFORE_PATTERN = Pattern.compile("\\d+(?=\u5e74[\u4ee5\u4e4b]?\u524d)");
    private static final Pattern YEAR_AFTER_PATTERN = Pattern.compile("\\d+(?=\u5e74[\u4ee5\u4e4b]?\u540e)");
    private static final Pattern CYCLE_UNIT_PATTERN = Pattern.compile("((\u6bcf\u5929)|(\u6bcf\u5468[1-7])|(\u6bcf\u6708[1-31]\u53f7?)|\u6bcf\u5e74)");
    private static final Pattern LAST_MONTH_PATTERN = Pattern.compile("\u4e0a(\u4e2a)?\u6708");
    private static final Pattern THIS_MONTH_PATTERN = Pattern.compile("(\u672c|\u8fd9\u4e2a)\u6708");
    private static final Pattern NEXT_MONTH_PATTERN = Pattern.compile("\u4e0b(\u4e2a)?\u6708");
    private static final Pattern DAY_BEFORE_YESTERDAY_PATTERN = Pattern.compile("(?<!\u5927)\u524d\u5929");
    private static final Pattern TODAY_PATTERN = Pattern.compile("\u4eca(?!\u5e74)");
    private static final Pattern TOMORROW_PATTERN = Pattern.compile("\u660e(?!\u5e74)");
    private static final Pattern DAY_AFTER_TOMORROW_PATTERN = Pattern.compile("(?<!\u5927)\u540e\u5929");
    private static final Pattern BEFORE_LAST_WEEKDAY_PATTERN = Pattern.compile("(?<=(\u4e0a\u4e0a(\u5468|\u661f\u671f)))[1-7]");
    private static final Pattern LAST_WEEKDAY_PATTERN = Pattern.compile("(?<=((?<!\u4e0a)\u4e0a(\u5468|\u661f\u671f)))[1-7]");
    private static final Pattern NEXT_WEEKDAY_PATTERN = Pattern.compile("(?<=((?<!\u4e0b)\u4e0b(\u5468|\u661f\u671f)))[1-7]");
    private static final Pattern NEXT_NEXT_WEEKDAY_PATTERN = Pattern.compile("(?<=(\u4e0b\u4e0b(\u5468|\u661f\u671f)))[1-7]");
    private static final Pattern THIS_WEEKDAY_PATTERN = Pattern.compile("(?<=((?<!(\u4e0a|\u4e0b))(\u5468|\u661f\u671f)))[1-7]");

    public TimeEntityRecognizer() {
        this(TimeEntityRecognizer.class.getResourceAsStream("/time.regex"));
    }

    public TimeEntityRecognizer(String file) throws IOException {
        this(new FileInputStream(file));
    }

    public TimeEntityRecognizer(InputStream in) {
        try {
            this.regexList = IOUtils.readLines((InputStream)in, (String)"UTF-8").stream().map(StringUtils::stripToNull).filter(item -> StringUtils.isNotEmpty((CharSequence)item) && !item.startsWith("#")).distinct().collect(Collectors.toList());
        }
        catch (IOException e) {
            log.error("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25");
        }
        if (log.isTraceEnabled()) {
            log.trace("input regex[size={}, text={}]", (Object)this.regexList.size(), this.regexList);
        }
        long start = System.currentTimeMillis();
        this.pattern = Pattern.compile(this.regexList.stream().map(item -> "(" + item + ")").collect(Collectors.joining("|")));
        long end = System.currentTimeMillis();
    }

    public List<TimeEntity> parse(String text) {
        return this.parse(text, CHINA_TIME_ZONE);
    }

    public List<TimeEntity> parse(String text, TimeZone timeZone) {
        return this.parse(text, timeZone, Calendar.getInstance(timeZone).getTime());
    }

    public List<TimeEntity> parse(String text, TimeZone timeZone, Date relative) {
        TimeEntity timeEntity;
        int offset;
        ArrayList<TimeEntity> result = new ArrayList<TimeEntity>();
        Matcher match = this.pattern.matcher(text);
        while (match.find()) {
            TimeEntity lastEntity = result.isEmpty() ? null : (TimeEntity)result.get(result.size() - 1);
            offset = match.start();
            String matchedText = match.group();
            if (lastEntity != null && offset == lastEntity.getOffset() + lastEntity.getOriginal().length()) {
                lastEntity.setOriginal(lastEntity.getOriginal() + matchedText);
                continue;
            }
            timeEntity = new TimeEntity(matchedText, offset);
            result.add(timeEntity);
        }
        Iterator iterator = result.iterator();
        Date lastRelative = relative;
        while (iterator.hasNext()) {
            timeEntity = (TimeEntity)iterator.next();
            Date date = this.parseTime(timeEntity.getOriginal(), timeZone, lastRelative, lastRelative.equals(relative), timeEntity);
            if (null != date) {
                lastRelative = date;
                offset = timeEntity.getOffset();
                if (offset > 1 && text.charAt(offset - 1) == '\u5230') {
                    timeEntity.setStart(false);
                    timeEntity.setEnd(true);
                    continue;
                }
                if (offset + timeEntity.getOriginal().length() >= text.length() || text.charAt(offset + timeEntity.getOriginal().length()) != '\u5230') continue;
                timeEntity.setStart(true);
                timeEntity.setEnd(false);
                continue;
            }
            iterator.remove();
        }
        iterator = result.iterator();
        TimeEntity prev = null;
        while (iterator.hasNext()) {
            TimeEntity timeEntity2 = (TimeEntity)iterator.next();
            if (timeEntity2.isEnd() && prev == null) {
                timeEntity2.setEnd(false);
            } else if (timeEntity2.isStart() && !iterator.hasNext()) {
                timeEntity2.setStart(false);
            }
            if (timeEntity2.isEnd() && prev != null) {
                if (prev.getCycle() != null && timeEntity2.getCycle() == null) {
                    timeEntity2.setCycle(prev.getCycle());
                }
                if (prev.getValue().getTime() > timeEntity2.getValue().getTime()) {
                    timeEntity2.setValue(new Date(timeEntity2.getValue().getTime() + 43200000L));
                }
            }
            prev = timeEntity2;
        }
        return result;
    }

    private String normalizeTimeString(String text) {
        String holidayRes = Holiday2StringConverter.holidayDate(text);
        if (null != holidayRes) {
            text = holidayRes;
        }
        text = text.replace("\u793c\u62dc", "\u661f\u671f");
        text = text.replace("\u4eca\u513f", "\u4eca\u5929");
        text = text.replace("\u5468\u65e5", "\u54687").replace("\uff1a", ":");
        text = text.replace("\u5468\u5929", "\u54687");
        text = text.replace("\u661f\u671f\u65e5", "\u661f\u671f7");
        text = text.replace("\u661f\u671f\u5929", "\u661f\u671f7");
        Matcher m = NUMBER_P.matcher(text);
        StringBuffer sb = new StringBuffer();
        boolean result = m.find();
        while (result) {
            String group = m.group();
            Double number = ChineseNumbers.chineseNumberToEnglish(group);
            m.appendReplacement(sb, String.valueOf(((Number)number).intValue()));
            result = m.find();
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private boolean validTime(int[] arr) {
        int sum = Arrays.stream(arr).sum();
        if (arr[1] > 12) {
            return false;
        }
        if (arr[2] > 31) {
            return false;
        }
        if (arr[3] > 24) {
            return false;
        }
        if (arr[4] > 59) {
            return false;
        }
        if (arr[5] > 59) {
            return false;
        }
        return sum != -6;
    }

    private Date parseTime(String text, TimeZone timeZone, Date relative, boolean isDefaultRelative, TimeEntity timeEntity) {
        text = this.normalizeTimeString(text);
        int year = this.parseYear(text);
        int month = this.parseMonth(text);
        int day = this.parseDay(text);
        int hour = this.parseHour(text);
        int minute = this.parseMinute(text);
        int second = this.parseSecond(text);
        int[] arr = new int[]{year, month, day, hour, minute, second};
        String cycle = this.parseCycle(text);
        if (null != cycle) {
            timeEntity.setCycle(Cycle.parseCycle(cycle));
        }
        this.overallParse(text, arr);
        this.parseRelative(text, timeZone, relative, arr);
        this.parseCurrentRelative(text, timeZone, relative, arr);
        if (!this.validTime(arr)) {
            return null;
        }
        this.normalize(text, arr, timeZone, relative, isDefaultRelative);
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.clear();
        int[] fields = new int[]{1, 2, 5, 11, 12, 13};
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] <= 0) continue;
            calendar.set(fields[i], arr[i]);
        }
        if (arr[1] > 0) {
            calendar.set(2, arr[1] - 1);
        }
        Date ret = calendar.getTime();
        timeEntity.setValue(calendar.getTime());
        if (arr[3] + arr[4] + arr[5] <= -3) {
            timeEntity.setDateOnly(true);
        }
        return ret;
    }

    private void normalize(String text, int[] arr, TimeZone timeZone, Date relative, boolean isDefaultRelative) {
        int j = 0;
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] < 0) continue;
            j = i;
            break;
        }
        Calendar calender = Calendar.getInstance(timeZone);
        Matcher matcher = TIME_MODIFIER_PATTERN.matcher(text);
        if (!matcher.find() && isDefaultRelative && arr[2] < 0 && arr[3] < calender.get(11) && arr[3] <= 12) {
            arr[3] = arr[3] + 12;
        }
        calender.setTime(relative);
        int[] fields = new int[]{1, 2, 5, 11, 12, 13};
        for (int i = 0; i < j; ++i) {
            if (arr[i] >= 0) continue;
            arr[i] = i == 1 ? calender.get(2) + 1 : calender.get(fields[i]);
        }
    }

    private int parseYear(String text) {
        int year = -1;
        Matcher match = YEAR_4_DIGIT_PATTERN.matcher(text);
        if (match.find()) {
            year = Integer.parseInt(match.group());
        } else {
            match = YEAR_2_DIGIT_PATTERN.matcher(text);
            if (match.find() && (year = Integer.parseInt(match.group())) >= 0 && year < 100) {
                year = year < 30 ? (year += 2000) : (year += 1900);
            }
        }
        return year;
    }

    private int parseMonth(String text) {
        Matcher match = MONTH_PATTERN.matcher(text);
        if (match.find()) {
            return Integer.parseInt(match.group());
        }
        return -1;
    }

    private int parseDay(String text) {
        Matcher match = DAY_PATTERN.matcher(text);
        if (match.find()) {
            return Integer.parseInt(match.group());
        }
        return -1;
    }

    private int parseHour(String text) {
        int hour = -1;
        Matcher match = HOUR_PATTERN.matcher(text);
        if (match.find()) {
            hour = Integer.parseInt(match.group());
        }
        if ((match = EARLY_MORNING_PATTERN.matcher(text)).find() && hour < 0) {
            hour = 1;
        }
        if ((match = MORNING_PATTERN.matcher(text)).find() && hour < 0) {
            hour = 6;
        }
        if ((match = FORENOON_PATTERN.matcher(text)).find() && hour < 0) {
            hour = 9;
        }
        if ((match = NOON_PATTERN.matcher(text)).find()) {
            if (hour >= 0 && hour <= 10) {
                hour += 12;
            } else if (hour < 0) {
                hour = 12;
            }
        }
        if ((match = AFTERNOON_PATTERN.matcher(text)).find()) {
            if (hour >= 0 && hour <= 11) {
                hour += 12;
            } else if (hour < 1) {
                hour = 14;
            }
        }
        if ((match = EVENING_PATTERN.matcher(text)).find()) {
            if (hour > 0 && hour < 11) {
                hour += 12;
            } else if (hour < 1) {
                hour = 18;
            }
        } else {
            match = NIGHT_PATTERN.matcher(text);
            if (match.find()) {
                if (hour >= 1 && hour <= 11) {
                    hour += 12;
                } else if (hour == 12) {
                    hour += 12;
                } else if (hour < 0) {
                    hour = 20;
                }
            }
        }
        return hour;
    }

    private int parseMinute(String text) {
        int minute = -1;
        Matcher match = MINUTE_PATTERN.matcher(text);
        if (match.find()) {
            minute = Integer.parseInt(match.group());
        }
        if ((match = ONE_QUARTER_PATTERN.matcher(text)).find()) {
            minute = 15;
        }
        if ((match = TWO_QUARTER_PATTERN.matcher(text)).find()) {
            minute = 30;
        }
        if ((match = THREE_QUARTER_PATTERN.matcher(text)).find()) {
            minute = 45;
        }
        return minute;
    }

    private int parseSecond(String text) {
        Matcher match = SECOND_PATTERN.matcher(text);
        if (match.find()) {
            return Integer.parseInt(match.group());
        }
        return -1;
    }

    private void overallParse(String text, int[] arr) {
        String[] splits;
        Matcher match = HOUR_MINUTE_SECOND_PATTERN.matcher(text);
        if (match.find()) {
            splits = match.group().split(":");
            arr[3] = Integer.parseInt(splits[0]);
            arr[4] = Integer.parseInt(splits[1]);
            arr[5] = Integer.parseInt(splits[2]);
        } else {
            match = HOUR_MINUTE_PATTERN.matcher(text);
            if (match.find()) {
                splits = match.group().split(":");
                arr[3] = Integer.parseInt(splits[0]);
                arr[4] = Integer.parseInt(splits[1]);
            }
        }
        match = NOON_PATTERN.matcher(text);
        if (match.find() && arr[3] >= 0 && arr[3] <= 10) {
            arr[3] = arr[3] + 12;
        }
        if ((match = AFTERNOON_PATTERN.matcher(text)).find() && arr[3] >= 0 && arr[3] <= 11) {
            arr[3] = arr[3] + 12;
        }
        if ((match = NIGHT_PATTERN.matcher(text)).find()) {
            if (arr[3] >= 1 && arr[3] <= 11) {
                arr[3] = arr[3] + 12;
            } else if (arr[3] == 12) {
                arr[3] = 0;
            }
        }
        if ((match = DASH_YEAR_MONTH_DAY.matcher(text)).find()) {
            splits = match.group().split("-");
            arr[0] = Integer.parseInt(splits[0]);
            arr[1] = Integer.parseInt(splits[1]);
            arr[2] = Integer.parseInt(splits[2]);
        }
        if ((match = SLASH_YEAR_MONTH_DAY.matcher(text)).find()) {
            splits = match.group().split("/");
            arr[1] = Integer.parseInt(splits[0]);
            arr[2] = Integer.parseInt(splits[1]);
            arr[0] = Integer.parseInt(splits[2]);
        }
        if ((match = DOT_YEAR_MONTH_DAY.matcher(text)).find()) {
            splits = match.group().split("\\.");
            arr[0] = Integer.parseInt(splits[0]);
            arr[1] = Integer.parseInt(splits[1]);
            arr[2] = Integer.parseInt(splits[2]);
        }
    }

    private void parseRelative(String text, TimeZone timeZone, Date relative, int[] arr) {
        int hour;
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setFirstDayOfWeek(2);
        calendar.setTime(relative);
        boolean[] flag = new boolean[]{false, false, false, false, false};
        Matcher match = HOURS_BEFORE_PATTERN.matcher(text);
        if (match.find()) {
            hour = Integer.parseInt(match.group());
            calendar.add(11, -hour);
            flag[3] = true;
            flag[4] = true;
        }
        if ((match = HOURS_AFTER_PATTERN.matcher(text)).find()) {
            hour = Integer.parseInt(match.group());
            calendar.add(11, hour);
            flag[3] = true;
            flag[4] = true;
        }
        if ((match = HALF_AN_HOUR_BEFORE_PATTERN.matcher(text)).find()) {
            String group = match.group();
            if (group.startsWith("\u534a")) {
                calendar.add(12, -30);
                flag[4] = true;
            } else {
                calendar.add(11, -Integer.parseInt(group.substring(0, 1)));
                calendar.add(12, -30);
                flag[3] = true;
                flag[4] = true;
            }
        }
        if ((match = HALF_AN_HOUR_AFTER_PATTERN.matcher(text)).find()) {
            String group = match.group();
            if (group.startsWith("\u534a")) {
                calendar.add(12, 30);
                flag[4] = true;
            } else {
                calendar.add(11, Integer.parseInt(group.substring(0, 1)));
                calendar.add(12, 30);
                flag[3] = true;
                flag[4] = true;
            }
        }
        if ((match = MINUTE_BEFORE_PATTERN.matcher(text)).find()) {
            int minute = Integer.parseInt(match.group());
            calendar.add(12, -minute);
            flag[4] = true;
        }
        if ((match = MINUTE_AFTER_PATTERN.matcher(text)).find()) {
            int minute = Integer.parseInt(match.group());
            calendar.add(12, minute);
            flag[4] = true;
        }
        if ((match = DAYS_BEFORE_PATTERN.matcher(text)).find()) {
            int day = Integer.parseInt(match.group());
            calendar.add(5, -day);
            flag[2] = true;
            flag[3] = true;
            flag[4] = true;
        }
        if ((match = DAYS_AFTER_PATTERN.matcher(text)).find()) {
            int day = Integer.parseInt(match.group());
            calendar.add(5, day);
            flag[2] = true;
            flag[3] = true;
            flag[4] = true;
        }
        if ((match = MONTH_BEFORE_PATTERN.matcher(text)).find()) {
            int month = Integer.parseInt(match.group());
            calendar.add(2, -month);
            flag[1] = true;
        }
        if ((match = MONTH_AFTER_PATTERN.matcher(text)).find()) {
            int month = Integer.parseInt(match.group());
            calendar.add(2, month);
            flag[1] = true;
        }
        if ((match = YEAR_BEFORE_PATTERN.matcher(text)).find()) {
            int year = Integer.parseInt(match.group());
            calendar.add(1, -year);
            flag[0] = true;
        }
        if ((match = YEAR_AFTER_PATTERN.matcher(text)).find()) {
            int year = Integer.parseInt(match.group());
            calendar.add(1, year);
            flag[0] = true;
        }
        if (flag[0] || flag[1] || flag[2] || flag[3] || flag[4]) {
            arr[0] = calendar.get(1);
        }
        if (flag[1] || flag[2] || flag[3] || flag[4]) {
            arr[1] = calendar.get(2) + 1;
        }
        if (flag[2] || flag[3] || flag[4]) {
            arr[2] = calendar.get(5);
        }
        if (flag[3] || flag[4]) {
            arr[3] = calendar.get(11);
        }
        if (flag[4]) {
            arr[4] = calendar.get(12);
        }
    }

    public String parseCycle(String text) {
        Matcher match = CYCLE_UNIT_PATTERN.matcher(text);
        if (match.find()) {
            return match.group();
        }
        return null;
    }

    public void parseCurrentRelative(String text, TimeZone timeZone, Date relative, int[] arr) {
        int week;
        Matcher match;
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setFirstDayOfWeek(2);
        calendar.setTime(relative);
        boolean[] flag = new boolean[]{false, false, false};
        if (text.contains("\u524d\u5e74")) {
            calendar.add(1, -2);
            flag[0] = true;
        }
        if (text.contains("\u53bb\u5e74")) {
            calendar.add(1, -1);
            flag[0] = true;
        }
        if (text.contains("\u4eca\u5e74")) {
            calendar.add(1, 0);
            flag[0] = true;
        }
        if (text.contains("\u660e\u5e74")) {
            calendar.add(1, 1);
            flag[0] = true;
        }
        if (text.contains("\u540e\u5e74")) {
            calendar.add(1, 2);
            flag[0] = true;
        }
        if ((match = LAST_MONTH_PATTERN.matcher(text)).find()) {
            calendar.add(2, -1);
            flag[1] = true;
        }
        if ((match = THIS_MONTH_PATTERN.matcher(text)).find()) {
            calendar.add(2, 0);
            flag[1] = true;
        }
        if ((match = NEXT_MONTH_PATTERN.matcher(text)).find()) {
            calendar.add(2, 1);
            flag[1] = true;
        }
        if (text.contains("\u5927\u5927\u524d\u5929")) {
            calendar.add(5, -4);
            flag[2] = true;
        } else if (text.contains("\u5927\u524d\u5929")) {
            calendar.add(5, -3);
            flag[2] = true;
        }
        match = DAY_BEFORE_YESTERDAY_PATTERN.matcher(text);
        if (match.find()) {
            calendar.add(5, -2);
            flag[2] = true;
        }
        if (text.contains("\u6628")) {
            calendar.add(5, -1);
            flag[2] = true;
        }
        if ((match = TODAY_PATTERN.matcher(text)).find()) {
            flag[2] = true;
        }
        if ((match = TOMORROW_PATTERN.matcher(text)).find()) {
            calendar.add(5, 1);
            flag[2] = true;
        }
        if ((match = DAY_AFTER_TOMORROW_PATTERN.matcher(text)).find()) {
            calendar.add(5, 2);
            flag[2] = true;
        }
        if (text.contains("\u5927\u5927\u540e\u5929")) {
            calendar.add(5, 4);
            flag[2] = true;
        } else if (text.contains("\u5927\u540e\u5929")) {
            calendar.add(5, 3);
            flag[2] = true;
        }
        match = BEFORE_LAST_WEEKDAY_PATTERN.matcher(text);
        if (match.find()) {
            week = Integer.parseInt(match.group());
            week = week == 7 ? 1 : ++week;
            calendar.add(4, -2);
            calendar.set(7, week);
            flag[2] = true;
        }
        if ((match = LAST_WEEKDAY_PATTERN.matcher(text)).find()) {
            week = Integer.parseInt(match.group());
            week = week == 7 ? 1 : ++week;
            calendar.add(4, -1);
            calendar.set(7, week);
            flag[2] = true;
        }
        if ((match = NEXT_WEEKDAY_PATTERN.matcher(text)).find()) {
            week = Integer.parseInt(match.group());
            week = week == 7 ? 1 : ++week;
            calendar.add(4, 1);
            calendar.set(7, week);
            flag[2] = true;
        }
        if ((match = NEXT_NEXT_WEEKDAY_PATTERN.matcher(text)).find()) {
            week = Integer.parseInt(match.group());
            week = week == 7 ? 1 : ++week;
            calendar.add(4, 2);
            calendar.set(7, week);
            flag[2] = true;
        }
        if ((match = THIS_WEEKDAY_PATTERN.matcher(text)).find()) {
            week = Integer.parseInt(match.group());
            week = week == 7 ? 1 : ++week;
            calendar.set(7, week);
            flag[2] = true;
        }
        if (flag[0] || flag[1] || flag[2]) {
            arr[0] = calendar.get(1);
        }
        if (flag[1] || flag[2]) {
            arr[1] = calendar.get(2) + 1;
        }
        if (flag[2]) {
            arr[2] = calendar.get(5);
        }
    }
}

