/*
 * Decompiled with CFR 0.152.
 */
package cn.mirrorming.text2date.time;

import cn.mirrorming.text2date.number.ChineseNumbers;
import cn.mirrorming.text2date.time.TimeDurationEntity;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeDurationEntityRecognizer {
    private static final Logger log = LoggerFactory.getLogger(TimeDurationEntityRecognizer.class);
    private static final long YEAR_IN_SECONDS = 31536000L;
    private static final long MONTH_IN_SECONDS = 2592000L;
    private static final long WEEK_IN_SECONDS = 2592000L;
    private static final long DAY_IN_SECONDS = 86400L;
    private static final long HOUR_IN_SECONDS = 3600L;
    private static final long MINUTE_IN_SECONDS = 60L;
    private Pattern pattern;
    private List<String> regexList;
    private static final Pattern YEAR_DURATION_PATTERN = Pattern.compile("([0-9\u4e00\u4e8c\u4e24\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341])(\u5e74)");
    private static final Pattern HALF_MONTH_DURATION_PATTERN = Pattern.compile("(\u534a\u4e2a?(\u6708))");
    private static final Pattern MONTH_DURATION_PATTERN = Pattern.compile("([0-9\u4e00\u4e8c\u4e24\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341]+)\u4e2a?(\u6708)");
    private static final Pattern WEEK_DURATION_PATTERN = Pattern.compile("([0-9\u4e00\u4e8c\u4e24\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341]+)(\u5468)");
    private static final Pattern DAY_DURATION_PATTERN = Pattern.compile("([0-9\u4e00\u4e8c\u4e24\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341]+)\u5929");
    private static final Pattern HALF_HOUR_DURATION_PATTERN = Pattern.compile("(\u534a\u4e2a?(\u5c0f\u65f6|\u949f\u5934))");
    private static final Pattern HOUR_DURATION_PATTERN = Pattern.compile("([0-9\u4e00\u4e8c\u4e24\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341]+)\u4e2a?(\u5c0f\u65f6|\u949f\u5934)");
    private static final Pattern MINUTE_PATTERN = Pattern.compile("([0-9\u4e00\u4e8c\u4e24\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341]+)(\u5206\u949f)");

    public TimeDurationEntityRecognizer() {
        this(TimeDurationEntityRecognizer.class.getResourceAsStream("/duration.regex"));
    }

    public TimeDurationEntityRecognizer(InputStream in) {
        try {
            this.regexList = IOUtils.readLines((InputStream)in, (String)"UTF-8").stream().map(StringUtils::stripToNull).filter(item -> StringUtils.isNotEmpty((CharSequence)item) && !item.startsWith("#")).distinct().collect(Collectors.toList());
        }
        catch (IOException e) {
            log.error("\u6587\u4ef6\u8bfb\u53d6\u9519\u8bef\uff01");
        }
        if (log.isTraceEnabled()) {
            log.trace("input regex[size={}, text={}]", (Object)this.regexList.size(), this.regexList);
        }
        long start = System.currentTimeMillis();
        this.pattern = Pattern.compile(this.regexList.stream().map(item -> "(" + item + ")").collect(Collectors.joining("|")));
        long end = System.currentTimeMillis();
        log.info("pattern initialized for {} patterns, time used(ms):{}", (Object)this.regexList.size(), (Object)(end - start));
    }

    public List<TimeDurationEntity> parse(String text) {
        ArrayList<TimeDurationEntity> result = new ArrayList<TimeDurationEntity>();
        Matcher match = this.pattern.matcher(text);
        while (match.find()) {
            TimeDurationEntity lastEntity = result.isEmpty() ? null : (TimeDurationEntity)result.get(result.size() - 1);
            int offset = match.start();
            String matchedText = match.group();
            if (lastEntity != null && offset == lastEntity.getOffset() + lastEntity.getOriginal().length()) {
                lastEntity.setOriginal(lastEntity.getOriginal() + matchedText);
                continue;
            }
            TimeDurationEntity timeDurationEntity = new TimeDurationEntity(matchedText, offset);
            result.add(timeDurationEntity);
        }
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            TimeDurationEntity timeDurationEntity = (TimeDurationEntity)iterator.next();
            Long duration = this.parseDuration(timeDurationEntity.getOriginal());
            if (null != duration) {
                timeDurationEntity.setValue(duration);
                continue;
            }
            iterator.remove();
        }
        return result;
    }

    private String normalizeDurationString(String text) {
        Pattern p = Pattern.compile("[\u4e00\u4e8c\u4e24\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341]+");
        Matcher m = p.matcher(text);
        StringBuffer sb = new StringBuffer();
        boolean result = m.find();
        while (result) {
            String group = m.group();
            Double number = ChineseNumbers.chineseNumberToEnglish(group);
            m.appendReplacement(sb, String.valueOf(((Number)number).intValue()));
            result = m.find();
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private Long parseDuration(String text) {
        text = this.normalizeDurationString(text);
        long year = this.parseYear(text);
        long month = this.parseMonth(text);
        long day = this.parseDay(text);
        long hour = this.parseHour(text);
        long minute = this.parseMinute(text);
        long[] arr = new long[]{year, month, day, hour, minute};
        if (!this.validTime(arr)) {
            return null;
        }
        return Arrays.stream(arr).filter(item -> item > 0L).sum();
    }

    private boolean validTime(long[] arr) {
        long sum = Arrays.stream(arr).sum();
        return sum > -5L;
    }

    private void normalize(int[] arr, Date relative, boolean isDefaultRelative) {
        int j = 0;
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] < 0) continue;
            j = i;
            break;
        }
        Calendar calender = Calendar.getInstance();
        if (isDefaultRelative && arr[2] < 0 && arr[3] < calender.get(11)) {
            arr[3] = arr[3] + 12;
        }
        calender.setTime(relative);
        int[] fields = new int[]{1, 2, 5, 11, 12, 13};
        for (int i = 0; i < j; ++i) {
            if (arr[i] >= 0) continue;
            arr[i] = i == 1 ? calender.get(2) + 1 : calender.get(fields[i]);
        }
    }

    private long parseYear(String text) {
        Matcher match;
        long year = -1L;
        if (text.contains("\u534a\u5e74")) {
            year = 15768000L;
        }
        if ((match = YEAR_DURATION_PATTERN.matcher(text)).find()) {
            year = (long)Integer.parseInt(match.group(1)) * 31536000L;
        }
        return year;
    }

    private long parseMonth(String text) {
        long month = -1L;
        Matcher match = HALF_MONTH_DURATION_PATTERN.matcher(text);
        if (match.find()) {
            month = 1296000L;
        } else {
            match = MONTH_DURATION_PATTERN.matcher(text);
            if (match.find()) {
                month = (long)Integer.parseInt(match.group(1)) * 2592000L;
            }
        }
        return month;
    }

    private long parseWeek(String text) {
        long week = -1L;
        Matcher match = WEEK_DURATION_PATTERN.matcher(text);
        week = (long)Integer.parseInt(match.group(1)) * 2592000L;
        return week;
    }

    private long parseDay(String text) {
        long day = -1L;
        if (text.contains("\u534a\u5929")) {
            day = 43200L;
        } else {
            Matcher match = DAY_DURATION_PATTERN.matcher(text);
            if (match.find()) {
                day = (long)Integer.parseInt(match.group(1)) * 86400L;
            }
        }
        return day;
    }

    private long parseHour(String text) {
        Matcher match = HALF_HOUR_DURATION_PATTERN.matcher(text);
        long hour = -1L;
        if (match.find()) {
            hour = 1800L;
        } else {
            match = HOUR_DURATION_PATTERN.matcher(text);
            if (match.find()) {
                hour = (long)Integer.parseInt(match.group(1)) * 3600L;
            }
        }
        return hour;
    }

    private long parseMinute(String text) {
        long minute = -1L;
        Matcher match = MINUTE_PATTERN.matcher(text);
        if (match.find()) {
            minute = (long)Integer.parseInt(match.group(1)) * 60L;
        }
        return minute;
    }
}

