/*
 * Decompiled with CFR 0.152.
 */
package cn.mirrorming.text2date.time;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class LunarGregorianConverter {
    private int[] result;
    private Calendar calendar;
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy.M.d EEEEE");
    private static int[] lunarInfo = new int[]{19416, 19168, 42352, 21717, 53856, 55632, 91476, 22176, 39632, 21970, 19168, 42422, 42192, 53840, 119381, 46400, 54944, 44450, 38320, 84343, 18800, 42160, 46261, 27216, 27968, 109396, 11104, 38256, 21234, 18800, 25958, 54432, 59984, 28309, 23248, 11104, 100067, 37600, 116951, 51536, 54432, 120998, 46416, 22176, 107956, 9680, 37584, 53938, 43344, 46423, 27808, 46416, 86869, 19872, 42448, 83315, 21200, 43432, 59728, 27296, 44710, 43856, 19296, 43748, 42352, 21088, 62051, 55632, 23383, 22176, 38608, 19925, 19152, 42192, 54484, 53840, 54616, 46400, 46496, 103846, 38320, 18864, 43380, 42160, 45690, 27216, 27968, 44870, 43872, 38256, 19189, 18800, 25776, 29859, 59984, 27480, 21952, 43872, 38613, 37600, 51552, 55636, 54432, 55888, 30034, 22176, 43959, 9680, 37584, 51893, 43344, 46240, 47780, 44368, 21977, 19360, 42416, 86390, 21168, 43312, 31060, 27296, 44368, 23378, 19296, 42726, 42208, 53856, 60005, 54576, 23200, 30371, 38608, 19415, 19152, 42192, 118966, 53840, 54560, 56645, 46496, 22224, 21938, 18864, 42359, 42160, 43600, 111189, 27936, 44448};
    private static final long[] S_TERM_INFO = new long[]{0L, 21208L, 42467L, 63836L, 85337L, 107014L, 128867L, 150921L, 173149L, 195551L, 218072L, 240693L, 263343L, 285989L, 308563L, 331033L, 353350L, 375494L, 397447L, 419210L, 440795L, 462224L, 483532L, 504758L};
    private static final String[] SOLAR_TERM = new String[]{"\u5c0f\u5bd2", "\u5927\u5bd2", "\u7acb\u6625", "\u96e8\u6c34", "\u60ca\u86f0", "\u6625\u5206", "\u6e05\u660e", "\u8c37\u96e8", "\u7acb\u590f", "\u5c0f\u6ee1", "\u8292\u79cd", "\u590f\u81f3", "\u5c0f\u6691", "\u5927\u6691", "\u7acb\u79cb", "\u5904\u6691", "\u767d\u9732", "\u79cb\u5206", "\u5bd2\u9732", "\u971c\u964d", "\u7acb\u51ac", "\u5c0f\u96ea", "\u5927\u96ea", "\u51ac\u81f3"};
    private static final Map<Integer, String> LUNAR_HOLIDAY_MAP = new HashMap<Integer, String>(11);
    private static final Map<Integer, String> HOLIDAY_MAP = new HashMap<Integer, String>(23);
    private static String[] Gan;
    private static String[] Zhi;
    private static String[] Animals;
    private static String[] nStr1;
    private static String[] nStr2;
    private static String[] monthNong;
    private static String[] yearName;

    public Calendar getCalendar() {
        return this.calendar;
    }

    public LunarGregorianConverter() {
        this.calendar = Calendar.getInstance(Locale.SIMPLIFIED_CHINESE);
        this.convert();
    }

    public LunarGregorianConverter(int year, int month, int day) {
        this.calendar = Calendar.getInstance();
        this.calendar.set(year, month - 1, day);
        this.convert();
    }

    public LunarGregorianConverter(int year, int month, int day, int hourOfDay, int minute) {
        this.calendar = Calendar.getInstance();
        this.calendar.set(year, month - 1, day, hourOfDay, minute);
        this.convert();
    }

    public LunarGregorianConverter(Date date) {
        this.calendar = Calendar.getInstance();
        this.calendar.setTime(date);
        this.convert();
    }

    public LunarGregorianConverter(Calendar calendar) {
        this.calendar = calendar;
        this.convert();
    }

    private static int totalDaysOfYear(int year) {
        int sum = 348;
        for (int i = 32768; i > 8; i >>= 1) {
            sum += (lunarInfo[year - 1900] & i) == 0 ? 0 : 1;
        }
        return sum + LunarGregorianConverter.leapDays(year);
    }

    private static int leapDays(int year) {
        int result = 0;
        if (LunarGregorianConverter.leapMonth(year) != 0) {
            result = (lunarInfo[year - 1900] & 0x10000) == 0 ? 29 : 30;
        }
        return result;
    }

    private static int leapMonth(int year) {
        return lunarInfo[year - 1900] & 0xF;
    }

    private static int monthDays(int y, int m) {
        return (lunarInfo[y - 1900] & 65536 >> m) == 0 ? 29 : 30;
    }

    private void convert() {
        int j;
        int i;
        Calendar baseCalendar = Calendar.getInstance();
        baseCalendar.set(1900, 0, 31, 0, 0, 0);
        Date baseDate = baseCalendar.getTime();
        int offset = (int)((this.calendar.getTimeInMillis() - baseDate.getTime()) / 86400000L);
        int monCyl = 14;
        int dayCyl = offset + 40;
        int temp = 0;
        for (i = 1900; i < 2050 && offset > 0; ++i) {
            temp = LunarGregorianConverter.totalDaysOfYear(i);
            offset -= temp;
            monCyl += 12;
        }
        if (offset < 0) {
            offset += temp;
            --i;
            monCyl -= 12;
        }
        int year = i;
        int yearCyl = i - 1864;
        int leap = LunarGregorianConverter.leapMonth(i);
        boolean isLeap = false;
        for (j = 1; j < 13 && offset > 0; ++j) {
            if (leap > 0 && j == leap + 1 && !isLeap) {
                --j;
                isLeap = true;
                temp = LunarGregorianConverter.leapDays(year);
            } else {
                temp = LunarGregorianConverter.monthDays(year, j);
            }
            if (isLeap && j == leap + 1) {
                isLeap = false;
            }
            offset -= temp;
            if (isLeap) continue;
            ++monCyl;
        }
        if (offset == 0 && leap > 0 && j == leap + 1) {
            if (isLeap) {
                isLeap = false;
            } else {
                isLeap = true;
                --j;
                --monCyl;
            }
        }
        if (offset < 0) {
            offset += temp;
            --j;
            --monCyl;
        }
        int month = j;
        int day = offset + 1;
        this.result = new int[]{year, month, day, isLeap ? 1 : 0, yearCyl, monCyl, dayCyl};
    }

    private static String cyclical(int num) {
        return Gan[num % 10] + Zhi[num % 12];
    }

    private static String chineseDay(int day) {
        String result;
        switch (day) {
            case 10: {
                result = "\u521d\u5341";
                break;
            }
            case 20: {
                result = "\u4e8c\u5341";
                break;
            }
            case 30: {
                result = "\u4e09\u5341";
                break;
            }
            default: {
                result = nStr2[day / 10];
                result = result + nStr1[day % 10];
            }
        }
        return result;
    }

    public static String chineseYear(int y) {
        String s = " ";
        while (y > 0) {
            int d = y % 10;
            y = (y - d) / 10;
            s = yearName[d] + s;
        }
        return s;
    }

    public String getLunarDate() {
        String s = sdf.format(this.calendar.getTime()) + " ";
        s = s + LunarGregorianConverter.cyclical(this.result[4]) + "[" + Animals[(this.result[0] - 4) % 12] + "]\u5e74 ";
        s = s + LunarGregorianConverter.cyclical(this.result[5]) + "\u6708 ";
        s = s + LunarGregorianConverter.cyclical(this.result[6]) + "\u65e5";
        return s;
    }

    public String getLunarDay() {
        return (this.result[3] == 1 ? "\u95f0" : "") + monthNong[this.result[1]] + "\u6708" + LunarGregorianConverter.chineseDay(this.result[2]);
    }

    public String getLunarMonth() {
        return (this.result[3] == 1 ? "\u95f0" : "") + monthNong[this.result[1]] + "\u6708";
    }

    public String getLunarDayOfMonth() {
        return LunarGregorianConverter.chineseDay(this.result[2]);
    }

    public String getLunarTime() {
        int hour = this.calendar.get(11);
        int timeOffset = this.result[6] % 10 * 24 + hour;
        return Gan[(timeOffset + 1) / 2 % 10] + Zhi[(hour + 1) / 2 % 12] + "\u65f6";
    }

    public String getSoralTerm() {
        int y = this.calendar.get(1);
        int m = this.calendar.get(2);
        int d = this.calendar.get(5);
        String solarTerms = d == this.sTerm(y, m * 2) ? SOLAR_TERM[m * 2] : (d == this.sTerm(y, m * 2 + 1) ? SOLAR_TERM[m * 2 + 1] : null);
        return solarTerms;
    }

    public int sTerm(int y, int n) {
        Calendar cal = Calendar.getInstance();
        cal.set(1900, 0, 6, 2, 5, 0);
        long temp = cal.getTime().getTime();
        cal.setTimeInMillis((long)(3.15569259747E10 * (double)(y - 1900) + (double)(S_TERM_INFO[n] * 60000L) + (double)temp));
        return cal.get(5);
    }

    public String getLunarHoliday() {
        int temp = this.result[2] == 29 && !this.isBigMonth(this.result[0], this.result[1]) ? (this.result[1] << 8) + 30 : (this.result[1] << 8) + this.result[2];
        return LUNAR_HOLIDAY_MAP.get(temp);
    }

    public String getHoliday() {
        int m = this.calendar.get(2) + 1;
        int d = this.calendar.get(5);
        int temp = (m << 8) + d;
        return HOLIDAY_MAP.get(temp);
    }

    private boolean isBigMonth(int y, int m) {
        return (lunarInfo[y - 1900] & 65536 >> m) != 0;
    }

    public void nextDay() {
        this.calendar.add(5, 1);
        this.convert();
    }

    public static void main(String[] args) {
        LunarGregorianConverter lunarGregorianConverter = new LunarGregorianConverter();
        boolean bigMonth = lunarGregorianConverter.isBigMonth(2019, 2);
        String lunarDate = lunarGregorianConverter.getLunarDate();
        String s2 = lunarGregorianConverter.getHoliday();
        String s3 = lunarGregorianConverter.getHoliday();
        String s4 = lunarGregorianConverter.getLunarMonth();
        String s5 = LunarGregorianConverter.chineseYear(2019);
        System.out.println(bigMonth);
    }

    static {
        LUNAR_HOLIDAY_MAP.put(257, "\u6625\u8282");
        LUNAR_HOLIDAY_MAP.put(271, "\u5143\u5bb5");
        LUNAR_HOLIDAY_MAP.put(1285, "\u7aef\u5348");
        LUNAR_HOLIDAY_MAP.put(1799, "\u4e03\u5915");
        LUNAR_HOLIDAY_MAP.put(1807, "\u4e2d\u5143");
        LUNAR_HOLIDAY_MAP.put(2063, "\u4e2d\u79cb");
        LUNAR_HOLIDAY_MAP.put(2313, "\u91cd\u9633");
        LUNAR_HOLIDAY_MAP.put(3080, "\u814a\u516b");
        LUNAR_HOLIDAY_MAP.put(3096, "\u5c0f\u5e74");
        LUNAR_HOLIDAY_MAP.put(3102, "\u9664\u5915");
        HOLIDAY_MAP.put(257, "\u5143\u65e6");
        HOLIDAY_MAP.put(526, "\u60c5\u4eba\u8282");
        HOLIDAY_MAP.put(776, "\u5987\u5973\u8282");
        HOLIDAY_MAP.put(780, "\u690d\u6811\u8282");
        HOLIDAY_MAP.put(783, "\u6d88\u8d39\u8005\u6743\u76ca\u65e5");
        HOLIDAY_MAP.put(1025, "\u611a\u4eba\u8282");
        HOLIDAY_MAP.put(1281, "\u52b3\u52a8\u8282");
        HOLIDAY_MAP.put(1284, "\u9752\u5e74\u8282");
        HOLIDAY_MAP.put(1292, "\u62a4\u58eb\u8282");
        HOLIDAY_MAP.put(1537, "\u513f\u7ae5\u8282");
        HOLIDAY_MAP.put(1793, "\u5efa\u515a\u8282");
        HOLIDAY_MAP.put(2049, "\u5efa\u519b\u8282");
        HOLIDAY_MAP.put(2056, "\u7238\u7238\u8282");
        HOLIDAY_MAP.put(2314, "\u6559\u5e08\u8282");
        HOLIDAY_MAP.put(2332, "\u5b54\u5b50\u8bde\u8fb0");
        HOLIDAY_MAP.put(2561, "\u56fd\u5e86\u8282");
        HOLIDAY_MAP.put(2566, "\u8001\u4eba\u8282");
        HOLIDAY_MAP.put(2584, "\u8054\u5408\u56fd\u65e5");
        HOLIDAY_MAP.put(2828, "\u5b59\u4e2d\u5c71\u8bde\u8fb0\u7eaa\u5ff5");
        HOLIDAY_MAP.put(3092, "\u6fb3\u95e8\u56de\u5f52\u7eaa\u5ff5");
        HOLIDAY_MAP.put(3097, "\u5723\u8bde");
        HOLIDAY_MAP.put(3096, "\u5e73\u5b89\u591c");
        HOLIDAY_MAP.put(2817, "\u4e07\u5723\u8282");
        Gan = new String[]{"\u7532", "\u4e59", "\u4e19", "\u4e01", "\u620a", "\u5df1", "\u5e9a", "\u8f9b", "\u58ec", "\u7678"};
        Zhi = new String[]{"\u5b50", "\u4e11", "\u5bc5", "\u536f", "\u8fb0", "\u5df3", "\u5348", "\u672a", "\u7533", "\u9149", "\u620c", "\u4ea5"};
        Animals = new String[]{"\u9f20", "\u725b", "\u864e", "\u5154", "\u9f99", "\u86c7", "\u9a6c", "\u7f8a", "\u7334", "\u9e21", "\u72d7", "\u732a"};
        nStr1 = new String[]{"\u65e5", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u5341"};
        nStr2 = new String[]{"\u521d", "\u5341", "\u5eff", "\u5345", "\u3000"};
        monthNong = new String[]{"\u6b63", "\u6b63", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u5341", "\u5341\u4e00", "\u5341\u4e8c"};
        yearName = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
    }
}

