/*
 * Decompiled with CFR 0.152.
 */
package cn.mirrorming.text2date.time;

import cn.mirrorming.text2date.time.LunarGregorianConverter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;

public class Holiday2StringConverter {
    public static final String[] HOLIDAY = new String[]{"\u5c0f\u5bd2", "\u5927\u5bd2", "\u7acb\u6625", "\u96e8\u6c34", "\u60ca\u86f0", "\u6625\u5206", "\u6e05\u660e", "\u8c37\u96e8", "\u7acb\u590f", "\u5c0f\u6ee1", "\u8292\u79cd", "\u590f\u81f3", "\u5c0f\u6691", "\u5927\u6691", "\u7acb\u79cb", "\u5904\u6691", "\u767d\u9732", "\u79cb\u5206", "\u5bd2\u9732", "\u971c\u964d", "\u7acb\u51ac", "\u5c0f\u96ea", "\u5927\u96ea", "\u51ac\u81f3", "\u6625\u8282", "\u5143\u5bb5", "\u7aef\u5348", "\u4e03\u5915", "\u4e2d\u5143", "\u4e2d\u79cb", "\u91cd\u9633", "\u814a\u516b", "\u5c0f\u5e74", "\u9664\u5915", "\u5143\u65e6", "\u60c5\u4eba\u8282", "\u5987\u5973\u8282", "\u690d\u6811\u8282", "\u6d88\u8d39\u8005\u6743\u76ca\u65e5", "\u611a\u4eba\u8282", "\u52b3\u52a8\u8282", "\u9752\u5e74\u8282", "\u62a4\u58eb\u8282", "\u513f\u7ae5\u8282", "\u5efa\u515a\u8282", "\u5efa\u519b\u8282", "\u7238\u7238\u8282", "\u6559\u5e08\u8282", "\u5b54\u5b50\u8bde\u8fb0", "\u56fd\u5e86\u8282", "\u8001\u4eba\u8282", "\u8054\u5408\u56fd\u65e5", "\u5b59\u4e2d\u5c71\u8bde\u8fb0\u7eaa\u5ff5", "\u6fb3\u95e8\u56de\u5f52\u7eaa\u5ff5", "\u5e73\u5b89\u591c", "\u4e07\u5723\u8282", "\u5723\u8bde"};
    private static HashMap<String, String> holidayMap = new HashMap();
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");

    public static String holidayDate(String holiday) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
        if (holiday.trim().contains("\u8282")) {
            String[] s = new String[]{"\u611f\u6069\u8282", "\u7236\u4eb2\u8282", "\u6bcd\u4eb2\u8282"};
            Calendar cal = Calendar.getInstance();
            if (holiday.equals(s[0])) {
                cal.set(2, 10);
                cal.set(4, 4);
                cal.set(7, 5);
                return simpleDateFormat.format(cal.getTime());
            }
            if (holiday.equals(s[1])) {
                cal.set(2, 5);
                cal.set(4, 3);
                cal.set(7, 1);
                return simpleDateFormat.format(cal.getTime());
            }
            if (holiday.equals(s[2])) {
                cal.set(2, 4);
                cal.set(4, 2);
                cal.set(7, 1);
                return simpleDateFormat.format(cal.getTime());
            }
        }
        if (holidayMap.containsKey(holiday)) {
            return holidayMap.get(holiday);
        }
        if (!holidayMap.containsKey(holiday) && holiday.contains("\u8282")) {
            holiday = holiday.replace("\u8282", "");
            return holidayMap.get(holiday);
        }
        return holidayMap.getOrDefault(holiday.concat("\u8282"), null);
    }

    static {
        for (String e : HOLIDAY) {
            holidayMap.put(e, "");
        }
        int year = Calendar.getInstance().get(1);
        LunarGregorianConverter time = new LunarGregorianConverter(year, 1, 1);
        int size = holidayMap.size();
        while (size > 0) {
            String value;
            String lunarHoliday = time.getLunarHoliday();
            String holiday = time.getHoliday();
            String solarTerms = time.getSoralTerm();
            if (holidayMap.containsKey(lunarHoliday)) {
                value = sdf.format(time.getCalendar().getTime());
                holidayMap.put(lunarHoliday, value);
                --size;
            }
            if (holidayMap.containsKey(holiday)) {
                value = sdf.format(time.getCalendar().getTime());
                holidayMap.put(holiday, value);
                --size;
            }
            if (holidayMap.containsKey(solarTerms)) {
                value = sdf.format(time.getCalendar().getTime());
                holidayMap.put(solarTerms, value);
                --size;
            }
            time.nextDay();
        }
    }
}

