/*
 * Decompiled with CFR 0.152.
 */
package cn.mirrorming.text2date.time;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Cycle {
    public static final int CYCLE_TYPE_NONE = 0;
    public static final int CYCLE_TYPE_DAY = 1;
    public static final int CYCLE_TYPE_WEEK = 2;
    public static final int CYCLE_TYPE_MONTH = 3;
    public static final int CYCLE_TYPE_YEAR = 4;
    private static final Map<Integer, String> TYPE_DESC_DICT = new HashMap<Integer, String>(){
        {
            this.put(0, "None");
            this.put(1, "Day");
            this.put(2, "Week");
            this.put(3, "Month");
            this.put(4, "Year");
        }
    };
    private int type = 0;
    private static Pattern WEEKLY_PATTERN = Pattern.compile("\u6bcf\u5468(\\d)");
    private static Pattern MONTHLY_PATTERN = Pattern.compile("\u6bcf\u6708([0-3]?[0-9])[\u65e5\u53f7]");
    private static Pattern YEAR_PATTERN = Pattern.compile("\u6bcf\u5e74([0-1]?[0-9])\u6708([0-3]?[0-9])[\u65e5\u53f7]");

    public Cycle(int type) {
        this.type = type;
    }

    public static Cycle parseCycle(String text) {
        int nth;
        if (text.contains("\u6bcf\u5929")) {
            return new Cycle(1);
        }
        Matcher matcher = WEEKLY_PATTERN.matcher(text);
        if (matcher.find() && (nth = Integer.parseInt(matcher.group(1))) >= 1 && nth <= 7) {
            return new Cycle(2);
        }
        matcher = MONTHLY_PATTERN.matcher(text);
        if (matcher.find() && (nth = Integer.parseInt(matcher.group(1))) >= 1 && nth <= 31) {
            return new Cycle(3);
        }
        matcher = YEAR_PATTERN.matcher(text);
        if (matcher.find()) {
            int month = Integer.parseInt(matcher.group(1));
            int day = Integer.parseInt(matcher.group(2));
            if (day >= 1 && day <= 31 && month >= 1 && month <= 12) {
                return new Cycle(4);
            }
        }
        return null;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Cycle)) {
            return false;
        }
        Cycle other = (Cycle)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getType() == other.getType();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Cycle;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getType();
        return result;
    }

    public String toString() {
        return "Cycle(type=" + this.getType() + ")";
    }
}

