/*
 * Decompiled with CFR 0.152.
 */
package cn.mirrorming.text2date.number;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChineseNumbers {
    private static final Logger log = LoggerFactory.getLogger(ChineseNumbers.class);
    private static final String[] DIGITS = new String[]{"\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};
    private static final Map<Character, Integer> DIGITS_MAP = new HashMap<Character, Integer>();
    private static final Pattern DIGITS_PATTERN;
    private static final Pattern ENGLISH_DECIMAL_PATTERN;
    private static final Pattern ENGLISH_FRACTION_PATTERN;
    private static final String[] BEFORE_WAN_DIGITS;
    private static final Map<String, Integer> BEFORE_WAN_DIGITS_MAP;
    private static final String[] AFTER_WAN_DIGITS;
    private static final Map<String, Long> AFTER_WAN_DIGITS_MAP;
    private static final Map<String, String> TRADITIONAL_TO_SIMPLE_MAP;
    private static final Map<String, String> TRADITIONAL_TO_FORMAL_MAP;
    private static final Map<String, String> TRADITIONAL_TO_PINYIN_MAP;
    private static final String MINUS = "\u8d1f";
    private static final String DECIMAL = "\u70b9";
    private static final String FRACTION = "\u5206\u4e4b";

    public static String englishNumberToChinese(String text) {
        Matcher m;
        if (StringUtils.isEmpty((CharSequence)text)) {
            throw new IllegalArgumentException("empty input");
        }
        boolean negative = false;
        if (text.length() == 1 && text.charAt(0) == '0') {
            return DIGITS[0];
        }
        if (text.charAt(0) == '-') {
            negative = true;
            text = text.substring(1);
        }
        String result = (m = ENGLISH_DECIMAL_PATTERN.matcher(text)).find() ? ChineseNumbers.englishNumberToChineseFull(m.group(1)) + DECIMAL + ChineseNumbers.englishNumberToChineseBrief(m.group(2)) : ((m = ENGLISH_FRACTION_PATTERN.matcher(text)).find() ? ChineseNumbers.englishNumberToChineseFull(m.group(2)) + FRACTION + ChineseNumbers.englishNumberToChineseFull(m.group(1)) : ChineseNumbers.englishNumberToChineseFull(text));
        if (negative) {
            result = MINUS + result;
        }
        return result;
    }

    private static String englishNumberToChineseBrief(String text) {
        String result = "";
        for (int i = 0; i < text.length(); ++i) {
            result = result + DIGITS[text.charAt(i) - 48];
        }
        return result;
    }

    private static String englishNumberToChineseFull(String text) {
        int power = 0;
        boolean canAddZero = false;
        boolean inZero = false;
        HashMap<Integer, Integer> powers = new HashMap<Integer, Integer>();
        long number = Long.parseLong(text);
        while (Math.pow(10.0, power) <= (double)number) {
            int value = (int)((double)number % Math.pow(10.0, power + 1) / Math.pow(10.0, power));
            powers.put(power, value);
            number = (long)((double)number - (double)number % Math.pow(10.0, power + 1));
            ++power;
        }
        String result = "";
        for (int i = 0; i < power; ++i) {
            if (i % 4 == 0) {
                if ((Integer)powers.get(i) != 0) {
                    inZero = false;
                    canAddZero = true;
                    result = DIGITS[(Integer)powers.get(i)] + AFTER_WAN_DIGITS[i / 4] + result;
                    continue;
                }
                if (!(i + 3 < power && (Integer)powers.get(i + 3) != 0 || i + 2 < power && (Integer)powers.get(i + 2) != 0) && (i + 1 >= power || (Integer)powers.get(i + 1) == 0)) continue;
                result = AFTER_WAN_DIGITS[i / 4] + result;
                canAddZero = false;
                continue;
            }
            if ((Integer)powers.get(i) != 0) {
                inZero = false;
                canAddZero = true;
                if (power == 2 && i == 1 && (Integer)powers.get(i) == 1) {
                    result = BEFORE_WAN_DIGITS[i % 4 - 1] + result;
                    continue;
                }
                result = DIGITS[(Integer)powers.get(i)] + BEFORE_WAN_DIGITS[i % 4 - 1] + result;
                continue;
            }
            if (!canAddZero || inZero) continue;
            inZero = true;
            result = DIGITS[(Integer)powers.get(i)] + result;
        }
        return result;
    }

    public static double chineseNumberToEnglish(String text) {
        double result;
        if (StringUtils.isEmpty((CharSequence)text)) {
            throw new IllegalArgumentException("empty input");
        }
        if (text.contains(FRACTION)) {
            int idx = text.indexOf(FRACTION);
            result = ChineseNumbers.chineseToEnglishFull(text.substring(idx + 2)) / ChineseNumbers.chineseToEnglishFull(text.substring(0, idx));
        } else {
            result = text.length() > 1 ? (DIGITS_PATTERN.matcher(text).find() ? (double)ChineseNumbers.chineseToEnglishBrief(text) : ChineseNumbers.chineseToEnglishFull(text)) : ChineseNumbers.chineseToEnglishFull(text);
        }
        return result;
    }

    private static long chineseToEnglishBrief(String text) {
        char[] chars = text.toCharArray();
        long total = 0L;
        for (int i = 0; i < chars.length; ++i) {
            total *= 10L;
            total += (long)DIGITS_MAP.get(Character.valueOf(chars[i])).intValue();
        }
        return total;
    }

    private static double chineseToEnglishFull(String text) {
        text = text.replace("\u4e07\u4ebf", "\u5146");
        text = text.replace("\u842c\u5104", "\u5146");
        text = text.replace("\u4ebf\u4e07", "\u5146");
        text = text.replace("\u5104\u842c", "\u5146");
        text = text.replace("\u500b", "");
        text = text.replace("\u4e2a", "");
        text = text.replace("\u5eff", "\u4e8c\u5341");
        text = text.replace("\u5344", "\u4e8c\u5341");
        text = text.replace("\u5345", "\u4e09\u5341");
        text = text.replace("\u534c", "\u56db\u5341");
        double total = 0.0;
        double levelTotal = 0.0;
        boolean negative = false;
        int power = 0;
        boolean afterDecimal = false;
        char[] chars = text.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (i == 0 && (c == '\u8d1f' || c == '\u8ca0' || c == '-')) {
                negative = true;
                continue;
            }
            if (i == 0 && c == '\u7b2c') continue;
            if (c == '\u9ede' || c == '\u70b9' || c == '.' || c == '\uff0e') {
                afterDecimal = true;
                power = -1;
                continue;
            }
            if (c == '\u5146') {
                power = 12;
                if (levelTotal == 0.0) {
                    levelTotal = 1.0;
                }
                total += levelTotal * Math.pow(10.0, power);
                levelTotal = 0.0;
                power -= 4;
                continue;
            }
            if (c == '\u4ebf' || c == '\u5104') {
                power = 8;
                if (levelTotal == 0.0) {
                    levelTotal = 1.0;
                }
                total += levelTotal * Math.pow(10.0, power);
                levelTotal = 0.0;
                power -= 4;
                continue;
            }
            if (c == '\u4e07' || c == '\u842c') {
                power = 4;
                if (levelTotal == 0.0) {
                    levelTotal = 1.0;
                }
                total += levelTotal * Math.pow(10.0, power);
                levelTotal = 0.0;
                power -= 4;
                continue;
            }
            if (c == '\u5343' || c == '\u4edf') {
                levelTotal += 1000.0;
                continue;
            }
            if (c == '\u767e' || c == '\u4f70') {
                levelTotal += 100.0;
                continue;
            }
            if (c == '\u5341' || c == '\u62fe') {
                levelTotal += 10.0;
                continue;
            }
            if (c == '\u96f6' || c == '\u3007' || c == '0' || c == '\uff10') {
                power = 0;
                continue;
            }
            if (DIGITS_MAP.containsKey(Character.valueOf(c))) {
                long digitVal = DIGITS_MAP.get(Character.valueOf(c)).intValue();
                if (afterDecimal) {
                    levelTotal += (double)digitVal * Math.pow(10.0, power);
                    --power;
                    while (i + 1 < chars.length && DIGITS_MAP.containsKey(Character.valueOf(chars[i + 1]))) {
                        levelTotal += (double)DIGITS_MAP.get(Character.valueOf(chars[i + 1])).intValue() * Math.pow(10.0, power);
                        --power;
                        ++i;
                    }
                    continue;
                }
                if (i + 1 < chars.length) {
                    char nextChar = chars[i + 1];
                    if (nextChar == '\u5341' || nextChar == '\u62fe') {
                        levelTotal += (double)(digitVal * 10L);
                        ++i;
                        continue;
                    }
                    if (nextChar == '\u767e' || nextChar == '\u4f70') {
                        levelTotal += (double)(digitVal * 100L);
                        ++i;
                        continue;
                    }
                    if (nextChar == '\u5343' || nextChar == '\u4edf') {
                        levelTotal += (double)(digitVal * 1000L);
                        ++i;
                        continue;
                    }
                    if (DIGITS_MAP.containsKey(Character.valueOf(nextChar))) {
                        levelTotal *= 10.0;
                        levelTotal += (double)digitVal;
                        while (i + 1 < chars.length && DIGITS_MAP.containsKey(Character.valueOf(chars[i + 1]))) {
                            levelTotal *= 10.0;
                            levelTotal += (double)DIGITS_MAP.get(Character.valueOf(chars[i + 1])).intValue();
                            ++i;
                        }
                        continue;
                    }
                    levelTotal += (double)digitVal;
                    continue;
                }
                if (i > 0) {
                    char prevChar = chars[i - 1];
                    if (prevChar == '\u5146') {
                        levelTotal += (double)digitVal * Math.pow(10.0, 11.0);
                        continue;
                    }
                    if (prevChar == '\u4ebf' || prevChar == '\u5104') {
                        levelTotal += (double)digitVal * Math.pow(10.0, 7.0);
                        continue;
                    }
                    if (prevChar == '\u842c' || prevChar == '\u4e07') {
                        levelTotal += (double)(digitVal * 1000L);
                        continue;
                    }
                    if (prevChar == '\u5343' || prevChar == '\u4edf') {
                        levelTotal += (double)(digitVal * 100L);
                        continue;
                    }
                    if (prevChar == '\u767e' || prevChar == '\u4f70') {
                        levelTotal += (double)(digitVal * 10L);
                        continue;
                    }
                    levelTotal += (double)digitVal;
                    continue;
                }
                levelTotal += (double)digitVal;
                continue;
            }
            throw new IllegalArgumentException("bad input:" + text);
        }
        total += levelTotal;
        if (negative) {
            total = -total;
        }
        return total;
    }

    static {
        ENGLISH_DECIMAL_PATTERN = Pattern.compile("([0-9]*)\\.([0-9]+)");
        ENGLISH_FRACTION_PATTERN = Pattern.compile("([0-9]*)/([0-9]+)");
        BEFORE_WAN_DIGITS = new String[]{"\u5341", "\u767e", "\u5343"};
        BEFORE_WAN_DIGITS_MAP = new HashMap<String, Integer>();
        AFTER_WAN_DIGITS = new String[]{"", "\u842c", "\u5104", "\u5146", "\u4eac"};
        AFTER_WAN_DIGITS_MAP = new HashMap<String, Long>();
        TRADITIONAL_TO_SIMPLE_MAP = new HashMap<String, String>();
        TRADITIONAL_TO_FORMAL_MAP = new HashMap<String, String>();
        TRADITIONAL_TO_PINYIN_MAP = new HashMap<String, String>();
        DIGITS_MAP.put(Character.valueOf('0'), 0);
        DIGITS_MAP.put(Character.valueOf('1'), 1);
        DIGITS_MAP.put(Character.valueOf('2'), 2);
        DIGITS_MAP.put(Character.valueOf('3'), 3);
        DIGITS_MAP.put(Character.valueOf('4'), 4);
        DIGITS_MAP.put(Character.valueOf('5'), 5);
        DIGITS_MAP.put(Character.valueOf('6'), 6);
        DIGITS_MAP.put(Character.valueOf('7'), 7);
        DIGITS_MAP.put(Character.valueOf('8'), 8);
        DIGITS_MAP.put(Character.valueOf('9'), 9);
        DIGITS_MAP.put(Character.valueOf('\u3007'), 0);
        DIGITS_MAP.put(Character.valueOf('\u4e00'), 1);
        DIGITS_MAP.put(Character.valueOf('\u4e03'), 7);
        DIGITS_MAP.put(Character.valueOf('\u4e09'), 3);
        DIGITS_MAP.put(Character.valueOf('\u4e24'), 2);
        DIGITS_MAP.put(Character.valueOf('\u4e5d'), 9);
        DIGITS_MAP.put(Character.valueOf('\u4e8c'), 2);
        DIGITS_MAP.put(Character.valueOf('\u4e94'), 5);
        DIGITS_MAP.put(Character.valueOf('\u4f0d'), 5);
        DIGITS_MAP.put(Character.valueOf('\u5169'), 2);
        DIGITS_MAP.put(Character.valueOf('\u516b'), 8);
        DIGITS_MAP.put(Character.valueOf('\u516d'), 6);
        DIGITS_MAP.put(Character.valueOf('\u53c1'), 3);
        DIGITS_MAP.put(Character.valueOf('\u53c3'), 3);
        DIGITS_MAP.put(Character.valueOf('\u53c4'), 3);
        DIGITS_MAP.put(Character.valueOf('\u56db'), 4);
        DIGITS_MAP.put(Character.valueOf('\u58f9'), 1);
        DIGITS_MAP.put(Character.valueOf('\u634c'), 8);
        DIGITS_MAP.put(Character.valueOf('\u67d2'), 7);
        DIGITS_MAP.put(Character.valueOf('\u7396'), 9);
        DIGITS_MAP.put(Character.valueOf('\u8086'), 4);
        DIGITS_MAP.put(Character.valueOf('\u8cb3'), 2);
        DIGITS_MAP.put(Character.valueOf('\u8d30'), 2);
        DIGITS_MAP.put(Character.valueOf('\u9646'), 6);
        DIGITS_MAP.put(Character.valueOf('\u9678'), 6);
        DIGITS_MAP.put(Character.valueOf('\u96f6'), 0);
        DIGITS_MAP.put(Character.valueOf('\uff10'), 0);
        DIGITS_MAP.put(Character.valueOf('\uff11'), 1);
        DIGITS_MAP.put(Character.valueOf('\uff12'), 2);
        DIGITS_MAP.put(Character.valueOf('\uff13'), 3);
        DIGITS_MAP.put(Character.valueOf('\uff14'), 4);
        DIGITS_MAP.put(Character.valueOf('\uff15'), 5);
        DIGITS_MAP.put(Character.valueOf('\uff16'), 6);
        DIGITS_MAP.put(Character.valueOf('\uff17'), 7);
        DIGITS_MAP.put(Character.valueOf('\uff18'), 8);
        DIGITS_MAP.put(Character.valueOf('\uff19'), 9);
        String join = DIGITS_MAP.keySet().stream().map(String::valueOf).collect(Collectors.joining(""));
        String pattern = String.format("^[%s]+$", join);
        DIGITS_PATTERN = Pattern.compile(pattern);
        BEFORE_WAN_DIGITS_MAP.put("\u4edf", 1000);
        BEFORE_WAN_DIGITS_MAP.put("\u4f70", 100);
        BEFORE_WAN_DIGITS_MAP.put("\u5341", 10);
        BEFORE_WAN_DIGITS_MAP.put("\u5343", 1000);
        BEFORE_WAN_DIGITS_MAP.put("\u62fe", 10);
        BEFORE_WAN_DIGITS_MAP.put("\u767e", 100);
        AFTER_WAN_DIGITS_MAP.put("\u4e07", 10000L);
        AFTER_WAN_DIGITS_MAP.put("\u842c", 10000L);
        AFTER_WAN_DIGITS_MAP.put("\u4ebf", 100000000L);
        AFTER_WAN_DIGITS_MAP.put("\u5104", 100000000L);
        AFTER_WAN_DIGITS_MAP.put("\u5146", 1000000000000L);
        AFTER_WAN_DIGITS_MAP.put("\u4eac", 10000000000000000L);
        TRADITIONAL_TO_FORMAL_MAP.put("\u4e00", "\u58f9");
        TRADITIONAL_TO_FORMAL_MAP.put("\u4e00", "\u58f9");
        TRADITIONAL_TO_FORMAL_MAP.put("\u4e03", "\u67d2");
        TRADITIONAL_TO_FORMAL_MAP.put("\u4e03", "\u67d2");
        TRADITIONAL_TO_FORMAL_MAP.put("\u4e09", "\u53c3");
        TRADITIONAL_TO_FORMAL_MAP.put("\u4e09", "\u53c3");
        TRADITIONAL_TO_FORMAL_MAP.put("\u4e5d", "\u7396");
        TRADITIONAL_TO_FORMAL_MAP.put("\u4e5d", "\u7396");
        TRADITIONAL_TO_FORMAL_MAP.put("\u4e8c", "\u8cb3");
        TRADITIONAL_TO_FORMAL_MAP.put("\u4e8c", "\u8cb3");
        TRADITIONAL_TO_FORMAL_MAP.put("\u4e94", "\u4f0d");
        TRADITIONAL_TO_FORMAL_MAP.put("\u4e94", "\u4f0d");
        TRADITIONAL_TO_FORMAL_MAP.put("\u5104", "\u5104");
        TRADITIONAL_TO_FORMAL_MAP.put("\u5104", "\u5104");
        TRADITIONAL_TO_FORMAL_MAP.put("\u5146", "\u5146");
        TRADITIONAL_TO_FORMAL_MAP.put("\u5146", "\u5146");
        TRADITIONAL_TO_FORMAL_MAP.put("\u5169", "\u5169");
        TRADITIONAL_TO_FORMAL_MAP.put("\u5169", "\u5169");
        TRADITIONAL_TO_FORMAL_MAP.put("\u516b", "\u634c");
        TRADITIONAL_TO_FORMAL_MAP.put("\u516b", "\u634c");
        TRADITIONAL_TO_FORMAL_MAP.put("\u516d", "\u9678");
        TRADITIONAL_TO_FORMAL_MAP.put("\u516d", "\u9678");
        TRADITIONAL_TO_FORMAL_MAP.put("\u5341", "\u62fe");
        TRADITIONAL_TO_FORMAL_MAP.put("\u5341", "\u62fe");
        TRADITIONAL_TO_FORMAL_MAP.put("\u5343", "\u4edf");
        TRADITIONAL_TO_FORMAL_MAP.put("\u5343", "\u4edf");
        TRADITIONAL_TO_FORMAL_MAP.put("\u56db", "\u8086");
        TRADITIONAL_TO_FORMAL_MAP.put("\u56db", "\u8086");
        TRADITIONAL_TO_FORMAL_MAP.put("\u767e", "\u4f70");
        TRADITIONAL_TO_FORMAL_MAP.put("\u767e", "\u4f70");
        TRADITIONAL_TO_FORMAL_MAP.put("\u842c", "\u842c");
        TRADITIONAL_TO_FORMAL_MAP.put("\u842c", "\u842c");
        TRADITIONAL_TO_FORMAL_MAP.put("\u8ca0", "\u8ca0");
        TRADITIONAL_TO_FORMAL_MAP.put("\u8ca0", "\u8ca0");
        TRADITIONAL_TO_FORMAL_MAP.put("\u96f6", "\u96f6");
        TRADITIONAL_TO_FORMAL_MAP.put("\u96f6", "\u96f6");
        TRADITIONAL_TO_FORMAL_MAP.put("\u9ede", "\u9ede");
        TRADITIONAL_TO_FORMAL_MAP.put("\u9ede", "\u9ede");
        TRADITIONAL_TO_PINYIN_MAP.put("\u4e00", "yi1");
        TRADITIONAL_TO_PINYIN_MAP.put("\u4e03", "qi1");
        TRADITIONAL_TO_PINYIN_MAP.put("\u4e09", "san1");
        TRADITIONAL_TO_PINYIN_MAP.put("\u4e5d", "jiu3");
        TRADITIONAL_TO_PINYIN_MAP.put("\u4e8c", "er4");
        TRADITIONAL_TO_PINYIN_MAP.put("\u4e94", "wu3");
        TRADITIONAL_TO_PINYIN_MAP.put("\u5104", "yi4");
        TRADITIONAL_TO_PINYIN_MAP.put("\u5146", "zhao4");
        TRADITIONAL_TO_PINYIN_MAP.put("\u5169", "liang3");
        TRADITIONAL_TO_PINYIN_MAP.put("\u516b", "ba1");
        TRADITIONAL_TO_PINYIN_MAP.put("\u516d", "liu4");
        TRADITIONAL_TO_PINYIN_MAP.put("\u5341", "shi2");
        TRADITIONAL_TO_PINYIN_MAP.put("\u5343", "qian1");
        TRADITIONAL_TO_PINYIN_MAP.put("\u56db", "si4");
        TRADITIONAL_TO_PINYIN_MAP.put("\u767e", "bai3");
        TRADITIONAL_TO_PINYIN_MAP.put("\u842c", "wan4");
        TRADITIONAL_TO_PINYIN_MAP.put("\u8ca0", "fu4");
        TRADITIONAL_TO_PINYIN_MAP.put("\u96f6", "ling2");
        TRADITIONAL_TO_PINYIN_MAP.put("\u9ede", "dian3");
        TRADITIONAL_TO_SIMPLE_MAP.put("\u4e00", "\u4e00");
        TRADITIONAL_TO_SIMPLE_MAP.put("\u4e03", "\u4e03");
        TRADITIONAL_TO_SIMPLE_MAP.put("\u4e09", "\u4e09");
        TRADITIONAL_TO_SIMPLE_MAP.put("\u4e5d", "\u4e5d");
        TRADITIONAL_TO_SIMPLE_MAP.put("\u4e8c", "\u4e8c");
        TRADITIONAL_TO_SIMPLE_MAP.put("\u4e94", "\u4e94");
        TRADITIONAL_TO_SIMPLE_MAP.put("\u5104", "\u4ebf");
        TRADITIONAL_TO_SIMPLE_MAP.put("\u5146", "\u5146");
        TRADITIONAL_TO_SIMPLE_MAP.put("\u5169", "\u4e24");
        TRADITIONAL_TO_SIMPLE_MAP.put("\u516b", "\u516b");
        TRADITIONAL_TO_SIMPLE_MAP.put("\u516d", "\u516d");
        TRADITIONAL_TO_SIMPLE_MAP.put("\u5341", "\u5341");
        TRADITIONAL_TO_SIMPLE_MAP.put("\u5343", "\u5343");
        TRADITIONAL_TO_SIMPLE_MAP.put("\u56db", "\u56db");
        TRADITIONAL_TO_SIMPLE_MAP.put("\u767e", "\u767e");
        TRADITIONAL_TO_SIMPLE_MAP.put("\u842c", "\u4e07");
        TRADITIONAL_TO_SIMPLE_MAP.put("\u8ca0", MINUS);
        TRADITIONAL_TO_SIMPLE_MAP.put("\u96f6", "\u96f6");
        TRADITIONAL_TO_SIMPLE_MAP.put("\u9ede", DECIMAL);
    }
}

