/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.classloaderhandler.ClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.classloaderhandler.ClassLoaderHandlerRegistry;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.AdditionOrderedSet;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ClasspathFinder {
    private final List<String> rawClasspathElements = new ArrayList<String>();
    private static CallerResolver CALLER_RESOLVER;

    public boolean addClasspathElement(String pathElement, LogNode log) {
        if (pathElement != null && !pathElement.isEmpty()) {
            this.rawClasspathElements.add(pathElement);
            if (log != null) {
                log.log("Adding classpath element: " + pathElement);
            }
            return true;
        }
        return false;
    }

    public boolean addClasspathElements(String pathStr, LogNode log) {
        if (pathStr != null && !pathStr.isEmpty()) {
            for (String pathElement : pathStr.split(File.pathSeparator)) {
                this.addClasspathElement(pathElement, log);
            }
            return true;
        }
        return false;
    }

    ClasspathFinder(ScanSpec scanSpec, LogNode log) {
        if (scanSpec.overrideClasspath != null) {
            LogNode overrideLog = log == null ? null : log.log("Overriding classpath");
            this.addClasspathElements(scanSpec.overrideClasspath, overrideLog);
        } else {
            ArrayList<ClassLoaderHandler> classLoaderHandlers = new ArrayList<ClassLoaderHandler>();
            for (Class<? extends ClassLoaderHandler> clazz : ClassLoaderHandlerRegistry.DEFAULT_CLASS_LOADER_HANDLERS) {
                try {
                    classLoaderHandlers.add(clazz.newInstance());
                }
                catch (IllegalAccessException | InstantiationException e) {
                    if (log == null) continue;
                    log.log("Could not instantiate " + clazz.getName(), e);
                }
            }
            for (Class<? extends ClassLoaderHandler> clazz : scanSpec.extraClassLoaderHandlers) {
                try {
                    classLoaderHandlers.add(clazz.newInstance());
                }
                catch (IllegalAccessException | InstantiationException e) {
                    if (log == null) continue;
                    log.log("Could not instantiate " + clazz.getName(), e);
                }
            }
            if (log != null) {
                LogNode classLoaderHandlerLog = log.log("ClassLoaderHandlers loaded:");
                for (ClassLoaderHandler classLoaderHandler : classLoaderHandlers) {
                    classLoaderHandlerLog.log(classLoaderHandler.getClass().getName());
                }
            }
            for (ClassLoader classLoader : scanSpec.classLoaders) {
                LogNode classLoaderLog = log == null ? null : log.log("Finding classpath elements in ClassLoader " + classLoader);
                boolean classloaderFound = false;
                for (ClassLoaderHandler handler : classLoaderHandlers) {
                    try {
                        if (!handler.handle(classLoader, this, classLoaderLog)) continue;
                        classloaderFound = true;
                        break;
                    }
                    catch (Exception e) {
                        if (classLoaderLog == null) continue;
                        classLoaderLog.log("Exception in ClassLoaderHandler", e);
                    }
                }
                if (classloaderFound || classLoaderLog == null) continue;
                classLoaderLog.log("Unknown ClassLoader type, cannot scan classes");
            }
            if (!scanSpec.overrideClassLoaders) {
                LogNode sysPropLog = log == null ? null : log.log("Getting classpath entries from java.class.path");
                this.addClasspathElements(System.getProperty("java.class.path"), sysPropLog);
            }
        }
    }

    public List<String> getRawClasspathElements() {
        return this.rawClasspathElements;
    }

    private static void addAllParentClassloaders(ClassLoader classLoader, AdditionOrderedSet<ClassLoader> classLoadersSetOut) {
        ArrayList<ClassLoader> callerClassLoaders = new ArrayList<ClassLoader>();
        for (ClassLoader cl = classLoader; cl != null; cl = cl.getParent()) {
            callerClassLoaders.add(cl);
        }
        for (int i = callerClassLoaders.size() - 1; i >= 0; --i) {
            classLoadersSetOut.add((ClassLoader)callerClassLoaders.get(i));
        }
    }

    private static void addAllParentClassloaders(Class<?> klass, AdditionOrderedSet<ClassLoader> classLoadersSetOut) {
        ClasspathFinder.addAllParentClassloaders(klass.getClassLoader(), classLoadersSetOut);
    }

    static List<ClassLoader> findAllClassLoaders(LogNode log) {
        AdditionOrderedSet<ClassLoader> classLoadersSet = new AdditionOrderedSet<ClassLoader>();
        ClasspathFinder.addAllParentClassloaders(ClassLoader.getSystemClassLoader(), classLoadersSet);
        if (CALLER_RESOLVER != null) {
            Class<?>[] callStack = CALLER_RESOLVER.getClassContext();
            for (Class<?> callStackClass : callStack) {
                ClasspathFinder.addAllParentClassloaders(callStackClass, classLoadersSet);
            }
        } else if (log != null) {
            log.log(ClasspathFinder.class.getSimpleName() + " could not create " + CallerResolver.class.getSimpleName() + ", current SecurityManager does not grant RuntimePermission(\"createSecurityManager\")");
        }
        ClasspathFinder.addAllParentClassloaders(Thread.currentThread().getContextClassLoader(), classLoadersSet);
        ClasspathFinder.addAllParentClassloaders(ClasspathFinder.class, classLoadersSet);
        List<ClassLoader> classLoaders = classLoadersSet.getList();
        classLoaders.remove(null);
        if (log != null) {
            for (ClassLoader classLoader : classLoaders) {
                log.log("Found ClassLoader " + classLoader.toString());
            }
            log.addElapsedTime();
        }
        return classLoaders;
    }

    static {
        try {
            CALLER_RESOLVER = new CallerResolver();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private static final class CallerResolver
    extends SecurityManager {
        private CallerResolver() {
        }

        @Override
        protected Class<?>[] getClassContext() {
            return super.getClassContext();
        }
    }
}

