/*
 * Decompiled with CFR 0.152.
 */
package elki.utilities.scaling.outlier;

import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDs;
import elki.result.OrderingResult;
import elki.result.outlier.OutlierResult;
import elki.utilities.datastructures.QuickSelect;
import elki.utilities.datastructures.arraylike.ArrayLikeUtil;
import elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.Flag;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.scaling.outlier.OutlierScaling;

public class TopKOutlierScaling
implements OutlierScaling {
    private int k = -1;
    private boolean binary = false;
    private double cutoff;
    private double ground;
    private double max;

    public TopKOutlierScaling(int k, boolean binary) {
        this.k = k;
        this.binary = binary;
    }

    @Override
    public void prepare(OutlierResult or) {
        OrderingResult ordering = or.getOrdering();
        DBIDs ids = ordering.getDBIDs();
        this.cutoff = or.getScores().doubleValue((DBIDRef)ordering.order(ids).iter().seek(Math.min(this.k, ids.size()) - 1));
        this.max = or.getOutlierMeta().getActualMaximum();
        this.ground = or.getOutlierMeta().getTheoreticalBaseline();
        this.ground = Double.isInfinite(this.ground) || Double.isNaN(this.ground) ? or.getOutlierMeta().getTheoreticalMinimum() : this.ground;
        this.ground = Double.isInfinite(this.ground) || Double.isNaN(this.ground) ? or.getOutlierMeta().getActualMinimum() : this.ground;
    }

    @Override
    public <A> void prepare(A array, NumberArrayAdapter<?, A> adapter) {
        double[] scores = ArrayLikeUtil.toPrimitiveDoubleArray(array, adapter);
        this.cutoff = QuickSelect.quickSelect((double[])scores, (int)(this.k - 1));
        this.max = Double.NEGATIVE_INFINITY;
        for (double v : scores) {
            this.max = Math.max(this.max, v);
        }
        this.ground = Math.min(0.0, this.cutoff);
    }

    public double getMax() {
        return this.binary ? 1.0 : this.max;
    }

    public double getMin() {
        return this.binary ? 0.0 : this.ground;
    }

    public double getScaled(double value) {
        return this.binary ? (value >= this.cutoff ? 1.0 : 0.0) : (value >= this.cutoff ? (value - this.ground) / (this.max - this.ground) : 0.0);
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID K_ID = new OptionID("topk.k", "Number of outliers to keep.");
        public static final OptionID BINARY_ID = new OptionID("topk.binary", "Make the top k a binary scaling.");
        private int k = -1;
        private boolean binary = false;

        public void configure(Parameterization config) {
            ((IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ONE_INT)).grab(config, x -> {
                this.k = x;
            });
            new Flag(BINARY_ID).grab(config, x -> {
                this.binary = x;
            });
        }

        public TopKOutlierScaling make() {
            return new TopKOutlierScaling(this.k, this.binary);
        }
    }
}

