/*
 * Decompiled with CFR 0.152.
 */
package elki.utilities.scaling.outlier;

import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.relation.DoubleRelation;
import elki.math.DoubleMinMax;
import elki.result.outlier.OutlierResult;
import elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import elki.utilities.scaling.outlier.OutlierScaling;

public class OutlierSqrtScaling
implements OutlierScaling {
    protected double min;
    protected double max;
    protected Double pmin = null;
    protected Double pmax = null;
    protected double factor;

    public OutlierSqrtScaling(Double pmin, Double pmax) {
        this.pmin = pmin;
        this.pmax = pmax;
    }

    public double getScaled(double value) {
        assert (this.factor != 0.0) : "prepare() was not run prior to using the scaling function.";
        return value <= this.min ? 0.0 : Math.min(1.0, Math.sqrt(value - this.min) / this.factor);
    }

    @Override
    public void prepare(OutlierResult or) {
        if (this.pmin == null || this.pmax == null) {
            DoubleMinMax mm = new DoubleMinMax();
            DoubleRelation scores = or.getScores();
            DBIDIter id = scores.iterDBIDs();
            while (id.valid()) {
                double val = scores.doubleValue((DBIDRef)id);
                if (!Double.isInfinite(val)) {
                    mm.put(val);
                }
                id.advance();
            }
            this.min = this.pmin == null ? mm.getMin() : this.pmin.doubleValue();
            this.max = this.pmax == null ? mm.getMax() : this.pmax.doubleValue();
        }
        this.factor = Math.sqrt(this.max - this.min);
    }

    @Override
    public <A> void prepare(A array, NumberArrayAdapter<?, A> adapter) {
        if (this.pmin == null || this.pmax == null) {
            DoubleMinMax mm = new DoubleMinMax();
            int size = adapter.size(array);
            for (int i = 0; i < size; ++i) {
                double val = adapter.getDouble(array, i);
                if (Double.isInfinite(val)) continue;
                mm.put(val);
            }
            this.min = this.pmin == null ? mm.getMin() : this.pmin.doubleValue();
            this.max = this.pmax == null ? mm.getMax() : this.pmax.doubleValue();
        }
        this.factor = Math.sqrt(this.max - this.min);
    }

    public double getMin() {
        return 0.0;
    }

    public double getMax() {
        return 1.0;
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID MIN_ID = new OptionID("sqrtscale.min", "Fixed minimum to use in sqrt scaling.");
        public static final OptionID MAX_ID = new OptionID("sqrtscale.max", "Fixed maximum to use in sqrt scaling.");
        protected double min;
        protected double max;

        public void configure(Parameterization config) {
            ((DoubleParameter)new DoubleParameter(MIN_ID).setOptional(true)).grab(config, x -> {
                this.min = x;
            });
            ((DoubleParameter)new DoubleParameter(MAX_ID).setOptional(true)).grab(config, x -> {
                this.max = x;
            });
        }

        public OutlierSqrtScaling make() {
            return new OutlierSqrtScaling(this.min, this.max);
        }
    }
}

