/*
 * Decompiled with CFR 0.152.
 */
package elki.utilities.scaling.outlier;

import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.relation.DoubleRelation;
import elki.math.MathUtil;
import elki.math.Mean;
import elki.math.MeanVariance;
import elki.math.statistics.distribution.NormalDistribution;
import elki.result.outlier.OutlierResult;
import elki.utilities.documentation.Reference;
import elki.utilities.scaling.outlier.StandardDeviationScaling;
import net.jafama.FastMath;

@Reference(authors="Hans-Peter Kriegel, Peer Kr\u00f6ger, Erich Schubert, Arthur Zimek", title="Interpreting and Unifying Outlier Scores", booktitle="Proc. 11th SIAM International Conference on Data Mining (SDM 2011)", url="https://doi.org/10.1137/1.9781611972818.2", bibkey="DBLP:conf/sdm/KriegelKSZ11")
public class MinusLogStandardDeviationScaling
extends StandardDeviationScaling {
    public MinusLogStandardDeviationScaling(double fixedmean, double lambda) {
        super(fixedmean, lambda);
    }

    @Override
    public double getScaled(double value) {
        assert (this.factor != 0.0) : "prepare() was not run prior to using the scaling function.";
        double mlogv = -FastMath.log((double)value);
        return mlogv < this.mean || Double.isNaN(mlogv) ? 0.0 : Math.max(0.0, NormalDistribution.erf((double)((mlogv - this.mean) / this.factor)));
    }

    @Override
    public void prepare(OutlierResult or) {
        if (Double.isNaN(this.fixedmean)) {
            MeanVariance mv = new MeanVariance();
            DoubleRelation scores = or.getScores();
            DBIDIter id = scores.iterDBIDs();
            while (id.valid()) {
                double val = -FastMath.log((double)scores.doubleValue((DBIDRef)id));
                if (!Double.isNaN(val) && !Double.isInfinite(val)) {
                    mv.put(val);
                }
                id.advance();
            }
            this.mean = mv.getMean();
            this.factor = this.lambda * mv.getSampleStddev() * MathUtil.SQRT2;
        } else {
            this.mean = this.fixedmean;
            Mean sqsum = new Mean();
            DoubleRelation scores = or.getScores();
            DBIDIter id = scores.iterDBIDs();
            while (id.valid()) {
                double val = -FastMath.log((double)scores.doubleValue((DBIDRef)id));
                if (!Double.isNaN(val) && !Double.isInfinite(val)) {
                    sqsum.put((val - this.mean) * (val - this.mean));
                }
                id.advance();
            }
            this.factor = this.lambda * Math.sqrt(sqsum.getMean()) * MathUtil.SQRT2;
        }
    }

    public static class Par
    extends StandardDeviationScaling.Par {
        @Override
        public MinusLogStandardDeviationScaling make() {
            return new MinusLogStandardDeviationScaling(this.fixedmean, this.lambda);
        }
    }
}

