/*
 * Decompiled with CFR 0.152.
 */
package elki.utilities.scaling.outlier;

import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.relation.DoubleRelation;
import elki.result.outlier.InvertedOutlierScoreMeta;
import elki.result.outlier.OutlierResult;
import elki.utilities.datastructures.arraylike.ArrayLikeUtil;
import elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import elki.utilities.exceptions.AbortException;
import elki.utilities.scaling.outlier.OutlierScaling;
import java.util.Arrays;
import net.jafama.FastMath;

public class LogRankingPseudoOutlierScaling
implements OutlierScaling {
    private double[] scores;
    private boolean inverted = false;

    @Override
    public void prepare(OutlierResult or) {
        DoubleRelation oscores = or.getScores();
        this.scores = new double[oscores.size()];
        int pos = 0;
        if (or.getOutlierMeta() instanceof InvertedOutlierScoreMeta) {
            this.inverted = true;
        }
        DBIDIter iditer = oscores.iterDBIDs();
        while (iditer.valid()) {
            this.scores[pos] = oscores.doubleValue((DBIDRef)iditer);
            ++pos;
            iditer.advance();
        }
        if (pos != oscores.size()) {
            throw new AbortException("Database size is incorrect!");
        }
        Arrays.sort(this.scores);
    }

    @Override
    public <A> void prepare(A array, NumberArrayAdapter<?, A> adapter) {
        this.scores = ArrayLikeUtil.toPrimitiveDoubleArray(array, adapter);
        Arrays.sort(this.scores);
    }

    public double getMax() {
        return 1.0;
    }

    public double getMin() {
        return 0.0;
    }

    public double getScaled(double value) {
        assert (this.scores != null) : "prepare() was not run prior to using the scaling function.";
        int pos = Arrays.binarySearch(this.scores, value);
        if (this.inverted) {
            return FastMath.log1p((double)(1.0 - (double)pos / ((double)this.scores.length - 1.0)));
        }
        return FastMath.log1p((double)((double)pos / ((double)this.scores.length - 1.0)));
    }
}

