/*
 * Decompiled with CFR 0.152.
 */
package elki.utilities.scaling.outlier;

import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.relation.DoubleRelation;
import elki.math.DoubleMinMax;
import elki.math.MeanVariance;
import elki.result.outlier.OutlierResult;
import elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import elki.utilities.documentation.Reference;
import elki.utilities.scaling.outlier.OutlierScaling;

@Reference(authors="H. V. Nguyen, H. H. Ang, V. Gopalkrishnan", title="Mining Outliers with Ensemble of Heterogeneous Detectors on Random Subspaces", booktitle="Proc. 15th Int. Conf. Database Systems for Advanced Applications (DASFAA 2010)", url="https://doi.org/10.1007/978-3-642-12026-8_29", bibkey="DBLP:conf/dasfaa/VuAG10")
public class HeDESNormalizationOutlierScaling
implements OutlierScaling {
    double mean;
    double stddev;
    double scaledmin;
    double scaledmax;

    @Override
    public void prepare(OutlierResult or) {
        MeanVariance mv = new MeanVariance();
        DoubleMinMax minmax = new DoubleMinMax();
        DoubleRelation scores = or.getScores();
        DBIDIter id = scores.iterDBIDs();
        while (id.valid()) {
            double val = scores.doubleValue((DBIDRef)id);
            if (!Double.isNaN(val) && !Double.isInfinite(val)) {
                mv.put(val);
                minmax.put(val);
            }
            id.advance();
        }
        this.mean = mv.getMean();
        this.stddev = mv.getSampleStddev();
        this.scaledmax = this.getScaled(minmax.getMax());
        this.scaledmin = this.getScaled(minmax.getMin());
    }

    @Override
    public <A> void prepare(A array, NumberArrayAdapter<?, A> adapter) {
        MeanVariance mv = new MeanVariance();
        DoubleMinMax minmax = new DoubleMinMax();
        int size = adapter.size(array);
        for (int i = 0; i < size; ++i) {
            double val = adapter.getDouble(array, i);
            if (Double.isNaN(val) || Double.isInfinite(val)) continue;
            mv.put(val);
            minmax.put(val);
        }
        this.mean = mv.getMean();
        this.stddev = mv.getSampleStddev();
        this.scaledmax = this.getScaled(minmax.getMax());
        this.scaledmin = this.getScaled(minmax.getMin());
    }

    public double getMax() {
        return this.scaledmax;
    }

    public double getMin() {
        return this.scaledmin;
    }

    public double getScaled(double value) {
        assert (this.stddev > 0.0 || value == this.mean) : "prepare() was not run prior to using the scaling function.";
        if (this.stddev > 0.0) {
            return (value - this.mean) / this.stddev;
        }
        return 0.0;
    }
}

