/*
 * Decompiled with CFR 0.152.
 */
package elki.result.outlier;

import elki.result.outlier.OutlierScoreMeta;

public class ProbabilisticOutlierScore
implements OutlierScoreMeta {
    private double actualMinimum = Double.NaN;
    private double actualMaximum = Double.NaN;
    private double theoreticalBaseline = Double.NaN;

    public ProbabilisticOutlierScore() {
        this(Double.NaN, Double.NaN, 0.0);
    }

    public ProbabilisticOutlierScore(double theoreticalBaseline) {
        this(Double.NaN, Double.NaN, theoreticalBaseline);
    }

    public ProbabilisticOutlierScore(double actualMinimum, double actualMaximum) {
        this(actualMinimum, actualMaximum, 0.0);
    }

    public ProbabilisticOutlierScore(double actualMinimum, double actualMaximum, double theoreticalBaseline) {
        this.actualMinimum = actualMinimum;
        this.actualMaximum = actualMaximum;
        this.theoreticalBaseline = theoreticalBaseline;
    }

    @Override
    public double getActualMinimum() {
        return this.actualMinimum;
    }

    @Override
    public double getActualMaximum() {
        return this.actualMaximum;
    }

    @Override
    public double getTheoreticalBaseline() {
        return this.theoreticalBaseline;
    }

    @Override
    public double getTheoreticalMaximum() {
        return 1.0;
    }

    @Override
    public double getTheoreticalMinimum() {
        return 0.0;
    }

    @Override
    public double normalizeScore(double value) {
        return value;
    }

    public String getLongName() {
        return "Outlier Score Metadata";
    }

    public String getShortName() {
        return "outlier-score-meta";
    }
}

