/*
 * Decompiled with CFR 0.152.
 */
package elki.result.outlier;

import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.relation.DoubleRelation;
import elki.database.relation.RelationUtil;
import elki.result.OrderingResult;
import java.util.Comparator;

public class OrderingFromRelation
implements OrderingResult {
    protected DoubleRelation scores;
    protected boolean ascending = false;

    public OrderingFromRelation(DoubleRelation scores, boolean ascending) {
        this.scores = scores;
        this.ascending = ascending;
    }

    public OrderingFromRelation(DoubleRelation scores) {
        this(scores, false);
    }

    public DBIDs getDBIDs() {
        return this.scores.getDBIDs();
    }

    public ArrayModifiableDBIDs order(DBIDs ids) {
        ArrayModifiableDBIDs sorted = DBIDUtil.newArray((DBIDs)ids);
        sorted.sort((Comparator)(this.ascending ? new RelationUtil.AscendingByDoubleRelation(this.scores) : new RelationUtil.DescendingByDoubleRelation(this.scores)));
        return sorted;
    }

    public String getLongName() {
        return this.scores.getLongName() + " Order";
    }
}

