/*
 * Decompiled with CFR 0.152.
 */
package elki.result.outlier;

import elki.logging.Logging;
import elki.result.outlier.OutlierScoreMeta;

public class BasicOutlierScoreMeta
implements OutlierScoreMeta {
    double actualMinimum = Double.NaN;
    double actualMaximum = Double.NaN;
    double theoreticalMinimum = Double.NaN;
    double theoreticalMaximum = Double.NaN;
    double theoreticalBaseline = Double.NaN;

    public BasicOutlierScoreMeta(double actualMinimum, double actualMaximum) {
        this(actualMinimum, actualMaximum, Double.NaN, Double.NaN, Double.NaN);
    }

    public BasicOutlierScoreMeta(double actualMinimum, double actualMaximum, double theoreticalMinimum, double theoreticalMaximum) {
        this(actualMinimum, actualMaximum, theoreticalMinimum, theoreticalMaximum, Double.NaN);
    }

    public BasicOutlierScoreMeta(double actualMinimum, double actualMaximum, double theoreticalMinimum, double theoreticalMaximum, double theoreticalBaseline) {
        if (Double.isNaN(actualMinimum) || Double.isNaN(actualMaximum)) {
            Logging.getLogger(this.getClass()).warning((CharSequence)("Warning: Outlier Score meta initalized with NaN values: " + actualMinimum + " - " + actualMaximum));
        }
        this.actualMinimum = actualMinimum;
        this.actualMaximum = actualMaximum;
        this.theoreticalMinimum = theoreticalMinimum;
        this.theoreticalMaximum = theoreticalMaximum;
        this.theoreticalBaseline = theoreticalBaseline;
    }

    @Override
    public double getActualMaximum() {
        return this.actualMaximum;
    }

    @Override
    public double getActualMinimum() {
        return this.actualMinimum;
    }

    @Override
    public double getTheoreticalBaseline() {
        return this.theoreticalBaseline;
    }

    @Override
    public double getTheoreticalMaximum() {
        return this.theoreticalMaximum;
    }

    @Override
    public double getTheoreticalMinimum() {
        return this.theoreticalMinimum;
    }

    @Override
    public double normalizeScore(double value) {
        double center = 0.0;
        if (!Double.isNaN(this.theoreticalBaseline) && !Double.isInfinite(this.theoreticalBaseline)) {
            center = this.theoreticalBaseline;
        } else if (!Double.isNaN(this.theoreticalMinimum) && !Double.isInfinite(this.theoreticalMinimum)) {
            center = this.theoreticalMinimum;
        } else if (!Double.isNaN(this.actualMinimum) && !Double.isInfinite(this.actualMinimum)) {
            center = this.actualMinimum;
        }
        if (value < center) {
            return 0.0;
        }
        double max = Double.NaN;
        if (!Double.isNaN(this.theoreticalMaximum) && !Double.isInfinite(this.theoreticalMaximum)) {
            max = this.theoreticalMaximum;
        } else if (!Double.isNaN(this.actualMaximum) && !Double.isInfinite(this.actualMaximum)) {
            max = this.actualMaximum;
        }
        if (!Double.isNaN(max) && !Double.isInfinite(max) && max >= center) {
            return (value - center) / (max - center);
        }
        return value - center;
    }

    public void setActualMinimum(double actualMinimum) {
        this.actualMinimum = actualMinimum;
    }

    public void setActualMaximum(double actualMaximum) {
        this.actualMaximum = actualMaximum;
    }

    public String getLongName() {
        return "Outlier Score Metadata";
    }

    public String getShortName() {
        return "outlier-score-meta";
    }
}

