/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.trivial;

import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDs;
import elki.database.relation.DoubleRelation;
import elki.database.relation.MaterializedDoubleRelation;
import elki.database.relation.Relation;
import elki.outlier.OutlierAlgorithm;
import elki.result.outlier.OutlierResult;
import elki.result.outlier.ProbabilisticOutlierScore;
import elki.utilities.Priority;

@Priority(value=-150)
public class TrivialNoOutlier
implements OutlierAlgorithm {
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{TypeUtil.ANY});
    }

    public OutlierResult run(Relation<?> relation) {
        WritableDoubleDataStore scores = DataStoreUtil.makeDoubleStorage((DBIDs)relation.getDBIDs(), (int)2);
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            scores.putDouble((DBIDRef)iditer, 0.0);
            iditer.advance();
        }
        MaterializedDoubleRelation scoreres = new MaterializedDoubleRelation("Trivial no-outlier score", relation.getDBIDs(), (DoubleDataStore)scores);
        ProbabilisticOutlierScore meta = new ProbabilisticOutlierScore();
        return new OutlierResult(meta, (DoubleRelation)scoreres);
    }
}

