/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.trivial;

import elki.data.NumberVector;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDs;
import elki.database.relation.DoubleRelation;
import elki.database.relation.MaterializedDoubleRelation;
import elki.database.relation.Relation;
import elki.math.DoubleMinMax;
import elki.math.Mean;
import elki.outlier.OutlierAlgorithm;
import elki.result.outlier.BasicOutlierScoreMeta;
import elki.result.outlier.OutlierResult;
import elki.utilities.Priority;

@Priority(value=-150)
public class TrivialAverageCoordinateOutlier
implements OutlierAlgorithm {
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{TypeUtil.NUMBER_VECTOR_VARIABLE_LENGTH});
    }

    public OutlierResult run(Relation<? extends NumberVector> relation) {
        WritableDoubleDataStore scores = DataStoreUtil.makeDoubleStorage((DBIDs)relation.getDBIDs(), (int)2);
        DoubleMinMax minmax = new DoubleMinMax();
        Mean m = new Mean();
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            m.reset();
            NumberVector nv = (NumberVector)relation.get((DBIDRef)iditer);
            for (int i = 0; i < nv.getDimensionality(); ++i) {
                m.put(nv.doubleValue(i));
            }
            double score = m.getMean();
            scores.putDouble((DBIDRef)iditer, score);
            minmax.put(score);
            iditer.advance();
        }
        MaterializedDoubleRelation scoreres = new MaterializedDoubleRelation("Trivial mean score", relation.getDBIDs(), (DoubleDataStore)scores);
        BasicOutlierScoreMeta meta = new BasicOutlierScoreMeta(minmax.getMin(), minmax.getMax());
        return new OutlierResult(meta, (DoubleRelation)scoreres);
    }
}

