/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.subspace;

import elki.data.NumberVector;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.DoubleDBIDList;
import elki.database.ids.DoubleDBIDListIter;
import elki.database.ids.ModifiableDoubleDBIDList;
import elki.database.relation.DoubleRelation;
import elki.database.relation.MaterializedDoubleRelation;
import elki.database.relation.Relation;
import elki.database.relation.RelationUtil;
import elki.distance.PrimitiveDistance;
import elki.distance.subspace.SubspaceEuclideanDistance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.math.DoubleMinMax;
import elki.math.MathUtil;
import elki.math.MeanVariance;
import elki.math.statistics.distribution.GammaDistribution;
import elki.math.statistics.kernelfunctions.EpanechnikovKernelDensityFunction;
import elki.math.statistics.kernelfunctions.KernelDensityFunction;
import elki.outlier.OutlierAlgorithm;
import elki.result.outlier.InvertedOutlierScoreMeta;
import elki.result.outlier.OutlierResult;
import elki.utilities.datastructures.BitsUtil;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import java.util.Arrays;
import net.jafama.FastMath;

@Reference(authors="E. M\u00fcller, M. Schiffer, T. Seidl", title="Adaptive outlierness for subspace outlier ranking", booktitle="Proc. 19th ACM Int. Conf. on Information and Knowledge Management", url="https://doi.org/10.1145/1871437.1871690", bibkey="DBLP:conf/cikm/MullerSS10")
public class OUTRES
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(OUTRES.class);
    private final double eps;
    private static final double K_S_CRITICAL001 = 1.63;

    public OUTRES(double eps) {
        this.eps = eps;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{TypeUtil.NUMBER_VECTOR_FIELD});
    }

    public OutlierResult run(Relation<? extends NumberVector> relation) {
        DBIDs ids = relation.getDBIDs();
        WritableDoubleDataStore ranks = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)4);
        DoubleMinMax minmax = new DoubleMinMax();
        KernelDensityEstimator kernel = new KernelDensityEstimator(relation, this.eps);
        long[] subspace = BitsUtil.zero((int)kernel.dim);
        FiniteProgress progress = LOG.isVerbose() ? new FiniteProgress("OUTRES scores", ids.size(), LOG) : null;
        DBIDIter iditer = ids.iter();
        while (iditer.valid()) {
            BitsUtil.zeroI((long[])subspace);
            double score = this.outresScore(0, subspace, (DBIDRef)iditer, kernel, ids);
            ranks.putDouble((DBIDRef)iditer, score);
            minmax.put(score);
            LOG.incrementProcessed((AbstractProgress)progress);
            iditer.advance();
        }
        LOG.ensureCompleted(progress);
        InvertedOutlierScoreMeta meta = new InvertedOutlierScoreMeta(minmax.getMin(), minmax.getMax(), 0.0, 1.0, 1.0);
        return new OutlierResult(meta, (DoubleRelation)new MaterializedDoubleRelation("OUTRES", ids, (DoubleDataStore)ranks));
    }

    public double outresScore(int s, long[] subspace, DBIDRef id, KernelDensityEstimator kernel, DBIDs cands) {
        double score = 1.0;
        SubspaceEuclideanDistance df = new SubspaceEuclideanDistance(subspace);
        MeanVariance meanv = new MeanVariance();
        ModifiableDoubleDBIDList neighcand = DBIDUtil.newDistanceDBIDList((int)cands.size());
        ModifiableDoubleDBIDList nn = DBIDUtil.newDistanceDBIDList((int)cands.size());
        for (int i = s; i < kernel.dim; ++i) {
            assert (!BitsUtil.get((long[])subspace, (int)i));
            BitsUtil.setI((long[])subspace, (int)i);
            df.setSelectedDimensions(subspace);
            double adjustedEps = kernel.adjustedEps(kernel.dim);
            DoubleDBIDList neigh = this.initialRange(id, cands, (PrimitiveDistance<? super NumberVector>)df, adjustedEps * 2.0, kernel, neighcand);
            if (neigh.size() > 2 && this.relevantSubspace(subspace, neigh, kernel)) {
                double density = kernel.subspaceDensity(subspace, neigh);
                meanv.reset();
                DoubleDBIDListIter neighbor = neigh.iter();
                while (neighbor.valid()) {
                    this.subsetNeighborhoodQuery((DoubleDBIDList)neighcand, (DBIDRef)neighbor, (PrimitiveDistance<? super NumberVector>)df, adjustedEps, kernel, nn);
                    meanv.put(kernel.subspaceDensity(subspace, (DoubleDBIDList)nn));
                    neighbor.advance();
                }
                double deviation = (meanv.getMean() - density) / (2.0 * meanv.getSampleStddev());
                if (deviation >= 1.0) {
                    score *= density / deviation;
                }
                score *= this.outresScore(i + 1, subspace, id, kernel, (DBIDs)neighcand);
            }
            BitsUtil.clearI((long[])subspace, (int)i);
        }
        return score;
    }

    private DoubleDBIDList initialRange(DBIDRef obj, DBIDs cands, PrimitiveDistance<? super NumberVector> df, double eps, KernelDensityEstimator kernel, ModifiableDoubleDBIDList n) {
        n.clear();
        NumberVector o = (NumberVector)kernel.relation.get(obj);
        double twoeps = eps * 2.0;
        int matches = 0;
        DBIDIter cand = cands.iter();
        while (cand.valid()) {
            double dist = df.distance((Object)o, kernel.relation.get((DBIDRef)cand));
            if (dist <= twoeps) {
                n.add(dist, (DBIDRef)cand);
                if (dist <= eps) {
                    ++matches;
                }
            }
            cand.advance();
        }
        return n.sort().slice(0, matches);
    }

    private DoubleDBIDList subsetNeighborhoodQuery(DoubleDBIDList neighc, DBIDRef dbid, PrimitiveDistance<? super NumberVector> df, double adjustedEps, KernelDensityEstimator kernel, ModifiableDoubleDBIDList n) {
        n.clear();
        NumberVector query = (NumberVector)kernel.relation.get(dbid);
        DoubleDBIDListIter neighbor = neighc.iter();
        while (neighbor.valid()) {
            double dist = df.distance((Object)query, kernel.relation.get((DBIDRef)neighbor));
            if (dist <= adjustedEps) {
                n.add(dist, (DBIDRef)neighbor);
            }
            neighbor.advance();
        }
        return n;
    }

    protected boolean relevantSubspace(long[] subspace, DoubleDBIDList neigh, KernelDensityEstimator kernel) {
        double crit = 1.63 / Math.sqrt(neigh.size() - 2);
        double[] data = new double[neigh.size()];
        Relation<? extends NumberVector> relation = kernel.relation;
        int dim = BitsUtil.nextSetBit((long[])subspace, (int)0);
        while (dim >= 0) {
            int count = 0;
            DoubleDBIDListIter neighbor = neigh.iter();
            while (neighbor.valid()) {
                data[count++] = ((NumberVector)relation.get((DBIDRef)neighbor)).doubleValue(dim);
                neighbor.advance();
            }
            assert (count == neigh.size());
            Arrays.sort(data);
            double min = data[0];
            double norm = data[data.length - 1] - min;
            boolean flag = false;
            int end = data.length - 1;
            for (int j = 1; j < end; ++j) {
                if (!(Math.abs((double)j / ((double)data.length - 2.0) - (data[j] - min) / norm) > crit)) continue;
                flag = true;
                break;
            }
            if (!flag) {
                return false;
            }
            dim = BitsUtil.nextSetBit((long[])subspace, (int)(dim + 1));
        }
        return true;
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID D_ID = new OptionID("outres.epsilon", "Range value for OUTRES in 2 dimensions.");
        protected double eps;

        public void configure(Parameterization config) {
            new DoubleParameter(D_ID).grab(config, x -> {
                this.eps = x;
            });
        }

        public OUTRES make() {
            return new OUTRES(this.eps);
        }
    }

    protected static class KernelDensityEstimator {
        final KernelDensityFunction kernel = EpanechnikovKernelDensityFunction.KERNEL;
        final Relation<? extends NumberVector> relation;
        final double[] epsilons;
        final double hopttwo;
        final int dim;

        public KernelDensityEstimator(Relation<? extends NumberVector> relation, double eps) {
            this.relation = relation;
            this.dim = RelationUtil.dimensionality(relation);
            this.hopttwo = this.optimalBandwidth(2);
            this.epsilons = new double[this.dim + 1];
            Arrays.fill(this.epsilons, Double.NEGATIVE_INFINITY);
            this.epsilons[2] = eps;
        }

        protected double subspaceDensity(long[] subspace, DoubleDBIDList neighbors) {
            double bandwidth = this.optimalBandwidth(BitsUtil.cardinality((long[])subspace));
            double density = 0.0;
            DoubleDBIDListIter neighbor = neighbors.iter();
            while (neighbor.valid()) {
                double v = neighbor.doubleValue() / bandwidth;
                density += v < 1.0 ? 1.0 - v * v : 0.0;
                neighbor.advance();
            }
            return density / (double)this.relation.size();
        }

        protected double optimalBandwidth(int dim) {
            double hopt = 8.0 * GammaDistribution.gamma((double)((double)dim / 2.0 + 1.0)) * (double)(dim + 4) * MathUtil.powi((double)2.0, (int)dim);
            return hopt * FastMath.pow((double)this.relation.size(), (double)(-1.0 / (double)(dim + 4)));
        }

        protected double adjustedEps(int dim) {
            double e = this.epsilons[dim];
            if (e < 0.0) {
                this.epsilons[dim] = e = this.epsilons[2] * this.optimalBandwidth(dim) / this.hopttwo;
            }
            return e;
        }
    }
}

