/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.subspace;

import elki.data.NumberVector;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDs;
import elki.database.relation.DoubleRelation;
import elki.database.relation.MaterializedDoubleRelation;
import elki.database.relation.Relation;
import elki.database.relation.RelationUtil;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.math.DoubleMinMax;
import elki.outlier.subspace.AbstractAggarwalYuOutlier;
import elki.result.outlier.InvertedOutlierScoreMeta;
import elki.result.outlier.OutlierResult;
import elki.utilities.documentation.Description;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.Title;
import elki.utilities.pairs.IntIntPair;
import java.util.ArrayList;
import java.util.Arrays;

@Title(value="BruteForce: Outlier detection for high dimensional data")
@Description(value="Examines all possible sets of k dimensional projections")
@Reference(authors="C. C. Aggarwal, P. S. Yu", title="Outlier detection for high dimensional data", booktitle="Proc. ACM SIGMOD Int. Conf. on Management of Data (SIGMOD 2001)", url="https://doi.org/10.1145/375663.375668", bibkey="DBLP:conf/sigmod/AggarwalY01")
public class AggarwalYuNaive
extends AbstractAggarwalYuOutlier {
    private static final Logging LOG = Logging.getLogger(AggarwalYuNaive.class);

    public AggarwalYuNaive(int k, int phi) {
        super(k, phi);
    }

    public OutlierResult run(Relation<? extends NumberVector> relation) {
        int i;
        int dim = RelationUtil.dimensionality(relation);
        int size = relation.size();
        ArrayList<ArrayList<DBIDs>> ranges = this.buildRanges(relation);
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Subspace size", this.k, LOG) : null;
        ArrayList<int[]> Rk = new ArrayList<int[]>();
        ArrayList<IntIntPair> q = new ArrayList<IntIntPair>();
        for (i = 0; i < dim; ++i) {
            int j = 0;
            while (j < this.phi) {
                q.add(new IntIntPair(i, j));
                Rk.add(new int[]{i, j++});
            }
        }
        LOG.incrementProcessed((AbstractProgress)prog);
        for (i = 2; i <= this.k; ++i) {
            ArrayList<int[]> Rnew = new ArrayList<int[]>();
            for (int j = 0; j < Rk.size(); ++j) {
                int[] c = (int[])Rk.get(j);
                for (IntIntPair pair : q) {
                    boolean invalid = false;
                    for (int t = 0; t < c.length; t += 2) {
                        if (c[t] != pair.first) continue;
                        invalid = true;
                        break;
                    }
                    if (invalid) continue;
                    int[] neu = Arrays.copyOf(c, c.length + 2);
                    neu[c.length] = pair.first;
                    neu[c.length + 1] = pair.second;
                    Rnew.add(neu);
                }
            }
            Rk = Rnew;
            LOG.incrementProcessed((AbstractProgress)prog);
        }
        if (prog != null) {
            prog.setProcessed(this.k, LOG);
        }
        LOG.ensureCompleted(prog);
        WritableDoubleDataStore sparsity = DataStoreUtil.makeDoubleStorage((DBIDs)relation.getDBIDs(), (int)6);
        for (int[] sub : Rk) {
            DBIDs ids = this.computeSubspace(sub, ranges);
            double sparsityC = AggarwalYuNaive.sparsity(ids.size(), size, this.k, this.phi);
            if (!(sparsityC < 0.0)) continue;
            DBIDIter iter = ids.iter();
            while (iter.valid()) {
                double prev = sparsity.doubleValue((DBIDRef)iter);
                if (Double.isNaN(prev) || sparsityC < prev) {
                    sparsity.putDouble((DBIDRef)iter, sparsityC);
                }
                iter.advance();
            }
        }
        DoubleMinMax minmax = new DoubleMinMax();
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            double val = sparsity.doubleValue((DBIDRef)iditer);
            if (Double.isNaN(val)) {
                sparsity.putDouble((DBIDRef)iditer, 0.0);
                val = 0.0;
            }
            minmax.put(val);
            iditer.advance();
        }
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("AggarwalYuNaive", relation.getDBIDs(), (DoubleDataStore)sparsity);
        InvertedOutlierScoreMeta meta = new InvertedOutlierScoreMeta(minmax.getMin(), minmax.getMax(), Double.NEGATIVE_INFINITY, 0.0);
        return new OutlierResult(meta, (DoubleRelation)scoreResult);
    }

    public static class Par
    extends AbstractAggarwalYuOutlier.Par {
        public AggarwalYuNaive make() {
            return new AggarwalYuNaive(this.k, this.phi);
        }
    }
}

