/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.subspace;

import elki.data.NumberVector;
import elki.data.VectorUtil;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDArrayMIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.HashSetModifiableDBIDs;
import elki.database.relation.Relation;
import elki.database.relation.RelationUtil;
import elki.math.MathUtil;
import elki.outlier.OutlierAlgorithm;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;
import java.util.ArrayList;
import java.util.Comparator;

@Reference(authors="C. C. Aggarwal, P. S. Yu", title="Outlier detection for high dimensional data", booktitle="Proc. ACM SIGMOD Int. Conf. on Management of Data (SIGMOD 2001)", url="https://doi.org/10.1145/375663.375668", bibkey="DBLP:conf/sigmod/AggarwalY01")
public abstract class AbstractAggarwalYuOutlier
implements OutlierAlgorithm {
    public static final short DONT_CARE = -1;
    public static final short GENE_OFFSET = 0;
    protected int phi;
    protected int k;

    public AbstractAggarwalYuOutlier(int k, int phi) {
        this.k = k;
        this.phi = phi;
    }

    protected ArrayList<ArrayList<DBIDs>> buildRanges(Relation<? extends NumberVector> relation) {
        int dim = RelationUtil.dimensionality(relation);
        int size = relation.size();
        ArrayList<ArrayList<DBIDs>> ranges = new ArrayList<ArrayList<DBIDs>>();
        ArrayModifiableDBIDs ids = DBIDUtil.newArray((DBIDs)relation.getDBIDs());
        VectorUtil.SortDBIDsBySingleDimension sorter = new VectorUtil.SortDBIDsBySingleDimension(relation);
        double part = (double)size * 1.0 / (double)this.phi;
        for (int d = 0; d < dim; ++d) {
            sorter.setDimension(d);
            ids.sort((Comparator)sorter);
            ArrayList<ArrayModifiableDBIDs> dimranges = new ArrayList<ArrayModifiableDBIDs>(this.phi + 1);
            int start = 0;
            DBIDArrayMIter iter = ids.iter();
            for (int r = 1; r <= this.phi; ++r) {
                int end = r < this.phi ? (int)(part * (double)r) : size;
                ArrayModifiableDBIDs currange = DBIDUtil.newArray((int)(end - start));
                iter.seek(start);
                while (iter.getOffset() < end) {
                    currange.add((DBIDRef)iter);
                    iter.advance();
                }
                start = end;
                dimranges.add(currange);
            }
            ranges.add(dimranges);
        }
        return ranges;
    }

    protected static double sparsity(int setsize, int dbsize, int k, double phi) {
        double fK = MathUtil.powi((double)(1.0 / phi), (int)k);
        return ((double)setsize - (double)dbsize * fK) / Math.sqrt((double)dbsize * fK * (1.0 - fK));
    }

    protected DBIDs computeSubspace(int[] subspace, ArrayList<ArrayList<DBIDs>> ranges) {
        HashSetModifiableDBIDs ids = DBIDUtil.newHashSet((DBIDs)ranges.get(subspace[0]).get(subspace[1]));
        int e = subspace.length - 1;
        for (int i = 2; i < e; i += 2) {
            DBIDs current = ranges.get(subspace[i]).get(subspace[i + 1] - 0);
            ids.retainAll(current);
            if (ids.isEmpty()) break;
        }
        return ids;
    }

    protected DBIDs computeSubspaceForGene(short[] gene, ArrayList<ArrayList<DBIDs>> ranges) {
        HashSetModifiableDBIDs m = null;
        for (int i = 0; i < gene.length; ++i) {
            if (gene[i] == -1) continue;
            DBIDs current = ranges.get(i).get(gene[i] - 0);
            if (m == null) {
                m = DBIDUtil.newHashSet((DBIDs)current);
                continue;
            }
            m.retainAll(current);
        }
        assert (m != null) : "All genes set to '*', should not happen!";
        return m;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{TypeUtil.NUMBER_VECTOR_FIELD});
    }

    public static abstract class Par
    implements Parameterizer {
        public static final OptionID PHI_ID = new OptionID("ay.phi", "The number of equi-depth grid ranges to use in each dimension.");
        public static final OptionID K_ID = new OptionID("ay.k", "Subspace dimensionality to search for.");
        protected int phi;
        protected int k;

        public void configure(Parameterization config) {
            ((IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ONE_INT)).grab(config, x -> {
                this.k = x;
            });
            ((IntParameter)new IntParameter(PHI_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ONE_INT)).grab(config, x -> {
                this.phi = x;
            });
        }
    }
}

