/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.spatial.neighborhood.weighted;

import elki.data.type.TypeInformation;
import elki.database.Database;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.DoubleDBIDPair;
import elki.database.relation.Relation;
import elki.outlier.spatial.neighborhood.NeighborSetPredicate;
import elki.outlier.spatial.neighborhood.weighted.WeightedNeighborSetPredicate;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.ArrayList;
import java.util.Collection;

public class UnweightedNeighborhoodAdapter
implements WeightedNeighborSetPredicate {
    NeighborSetPredicate inner;

    public UnweightedNeighborhoodAdapter(NeighborSetPredicate inner) {
        this.inner = inner;
    }

    @Override
    public Collection<DoubleDBIDPair> getWeightedNeighbors(DBIDRef reference) {
        DBIDs neighbors = this.inner.getNeighborDBIDs(reference);
        ArrayList<DoubleDBIDPair> adapted = new ArrayList<DoubleDBIDPair>(neighbors.size());
        DBIDIter iter = neighbors.iter();
        while (iter.valid()) {
            adapted.add(DBIDUtil.newPair((double)1.0, (DBIDRef)iter));
            iter.advance();
        }
        return adapted;
    }

    public static class Factory<O>
    implements WeightedNeighborSetPredicate.Factory<O> {
        NeighborSetPredicate.Factory<O> inner;

        public Factory(NeighborSetPredicate.Factory<O> inner) {
            this.inner = inner;
        }

        @Override
        public UnweightedNeighborhoodAdapter instantiate(Database database, Relation<? extends O> relation) {
            return new UnweightedNeighborhoodAdapter(this.inner.instantiate(database, relation));
        }

        @Override
        public TypeInformation getInputTypeRestriction() {
            return this.inner.getInputTypeRestriction();
        }

        public static class Par<O>
        implements Parameterizer {
            public static final OptionID INNER_ID = new OptionID("neighborhood.inner", "Parameter for the non-weighted neighborhood to use.");
            NeighborSetPredicate.Factory<O> inner;

            public void configure(Parameterization config) {
                new ObjectParameter(INNER_ID, NeighborSetPredicate.Factory.class).grab(config, x -> {
                    this.inner = x;
                });
            }

            public Factory<O> make() {
                return new Factory<O>(this.inner);
            }
        }
    }
}

